/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.user;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.model.response.Status;
import io.mambo.sdk.service.notification.model.NotificationDto;
import io.mambo.sdk.service.user.param.notification.UserClearNotificationsParams;
import io.mambo.sdk.service.user.param.notification.UserGetNotificationsParams;
import java.util.List;

public class UsersNotificationService
extends AbstractService {
    private static final String USER_SITE_URI = "/v1/{siteUrl}/users";
    private static final String USER_UUID_URI = "/v1/{siteUrl}/users/{uuid}";
    private static final String USER_NOTIFICATIONS_URI = "/v1/{siteUrl}/users/{uuid}/notifications";
    private static final String USER_CLEAR_NOTIFICATIONS_URI = "/v1/{siteUrl}/users/{uuid}/notifications/clear";

    protected UsersNotificationService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public List<NotificationDto> getNotifications(String siteUrl, String uuid) {
        return this.getNotifications(UserGetNotificationsParams.builder().siteUrl(siteUrl).uuid(uuid).build(), RequestOptions.create());
    }

    public List<NotificationDto> getNotifications(UserGetNotificationsParams params) {
        return this.getNotifications(params, RequestOptions.create());
    }

    public List<NotificationDto> getNotifications(UserGetNotificationsParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(USER_NOTIFICATIONS_URI).responseClass(NotificationDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public Status clearNotifications(String siteUrl, String uuid) {
        return this.clearNotifications(UserClearNotificationsParams.builder().siteUrl(siteUrl).uuid(uuid).build(), RequestOptions.create());
    }

    public Status clearNotifications(UserClearNotificationsParams params) {
        return this.clearNotifications(params, RequestOptions.create());
    }

    public Status clearNotifications(UserClearNotificationsParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(USER_CLEAR_NOTIFICATIONS_URI).responseClass(Status.class).method(HttpMethod.POST).params(params).options(requestOptions).build());
    }
}

