/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.user;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.data.CustomFieldValueRequestData;
import io.mambo.sdk.service.common.data.FileRequestData;
import io.mambo.sdk.service.common.model.CustomFieldValueDto;
import io.mambo.sdk.service.user.model.UserDto;
import io.mambo.sdk.service.user.param.customfield.UserCustomFieldParams;
import java.io.File;

public class UsersCustomFieldService
extends AbstractService {
    private static final String USER_SITE_URI = "/v1/{siteUrl}/users";
    private static final String USER_UUID_URI = "/v1/{siteUrl}/users/{uuid}";
    private static final String USER_CUSTOM_URI = "/v1/{siteUrl}/users/{uuid}/custom_fields";
    private static final String USER_CUSTOM_IMAGE_URI = "/v1/{siteUrl}/users/{uuid}/custom_fields/image";

    protected UsersCustomFieldService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public UserDto addCustomFields(String siteUrl, String uuid, CustomFieldValueRequestData data) {
        return this.modCustomFields(HttpMethod.POST, UserCustomFieldParams.builder().siteUrl(siteUrl).uuid(uuid).build(), data, RequestOptions.create());
    }

    public UserDto addCustomFields(UserCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.modCustomFields(HttpMethod.POST, params, data, RequestOptions.create());
    }

    public UserDto addCustomFields(UserCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return this.modCustomFields(HttpMethod.POST, params, data, requestOptions);
    }

    public UserDto updateCustomFields(String siteUrl, String uuid, CustomFieldValueRequestData data) {
        return this.modCustomFields(HttpMethod.PUT, UserCustomFieldParams.builder().siteUrl(siteUrl).uuid(uuid).build(), data, RequestOptions.create());
    }

    public UserDto updateCustomFields(UserCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.modCustomFields(HttpMethod.PUT, params, data, RequestOptions.create());
    }

    public UserDto updateCustomFields(UserCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return this.modCustomFields(HttpMethod.PUT, params, data, requestOptions);
    }

    public UserDto deleteCustomFields(String siteUrl, String uuid, CustomFieldValueRequestData data) {
        return this.modCustomFields(HttpMethod.DELETE, UserCustomFieldParams.builder().siteUrl(siteUrl).uuid(uuid).build(), data, RequestOptions.create());
    }

    public UserDto deleteCustomFields(UserCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.modCustomFields(HttpMethod.DELETE, params, data, RequestOptions.create());
    }

    public UserDto deleteCustomFields(UserCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return this.modCustomFields(HttpMethod.DELETE, params, data, requestOptions);
    }

    private UserDto modCustomFields(HttpMethod method, UserCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return (UserDto)this.apiClient().request(ApiRequest.builder().apiPath(USER_CUSTOM_URI).responseClass(UserDto.class).method(method).params(params).requestData(data).options(requestOptions).build());
    }

    public UserDto addCustomField(String siteUrl, String uuid, CustomFieldValueDto data, File image) {
        return this.addCustomField(UserCustomFieldParams.builder().siteUrl(siteUrl).uuid(uuid).build(), data, image, RequestOptions.create());
    }

    public UserDto addCustomField(UserCustomFieldParams params, CustomFieldValueDto data, File image) {
        return this.addCustomField(params, data, image, RequestOptions.create());
    }

    public UserDto addCustomField(UserCustomFieldParams params, CustomFieldValueDto data, File image, RequestOptions requestOptions) {
        return (UserDto)this.apiClient().request(ApiRequest.builder().apiPath(USER_CUSTOM_IMAGE_URI).responseClass(UserDto.class).method(HttpMethod.POST).params(params).requestData(new FileRequestData(image, data)).options(requestOptions).build());
    }
}

