/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.user;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.coupon.model.CouponStateDto;
import io.mambo.sdk.service.coupon.model.CouponStatesDto;
import io.mambo.sdk.service.user.param.coupon.UserGetAllCouponsParams;
import io.mambo.sdk.service.user.param.coupon.UserGetCouponsParams;
import java.util.List;

public class UsersCouponService
extends AbstractService {
    private static final String USER_SITE_URI = "/v1/{siteUrl}/users";
    private static final String USER_UUID_URI = "/v1/{siteUrl}/users/{uuid}";
    private static final String USER_COUPONS_URI = "/v1/{siteUrl}/users/{uuid}/coupons";
    private static final String USER_ALL_COUPONS_URI = "/v1/{siteUrl}/users/{uuid}/coupons/all";

    protected UsersCouponService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public List<CouponStateDto> getCoupons(String siteUrl, String uuid) {
        return this.getCoupons(UserGetCouponsParams.builder().siteUrl(siteUrl).uuid(uuid).build(), RequestOptions.create());
    }

    public List<CouponStateDto> getCoupons(UserGetCouponsParams params) {
        return this.getCoupons(params, RequestOptions.create());
    }

    public List<CouponStateDto> getCoupons(UserGetCouponsParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(USER_COUPONS_URI).responseClass(CouponStateDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public CouponStatesDto getAllCoupons(String siteUrl, String uuid) {
        return this.getAllCoupons(UserGetAllCouponsParams.builder().siteUrl(siteUrl).uuid(uuid).build(), RequestOptions.create());
    }

    public CouponStatesDto getAllCoupons(UserGetAllCouponsParams params) {
        return this.getAllCoupons(params, RequestOptions.create());
    }

    public CouponStatesDto getAllCoupons(UserGetAllCouponsParams params, RequestOptions requestOptions) {
        return (CouponStatesDto)this.apiClient().request(ApiRequest.builder().apiPath(USER_ALL_COUPONS_URI).responseClass(CouponStatesDto.class).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }
}

