/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.user;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.model.response.Status;
import io.mambo.sdk.service.user.model.UserDto;
import io.mambo.sdk.service.user.param.blacklist.UserBlacklistAddParams;
import io.mambo.sdk.service.user.param.blacklist.UserBlacklistGetListParams;
import io.mambo.sdk.service.user.param.blacklist.UserBlacklistRemoveParams;
import java.util.List;

public class UsersBlacklistService
extends AbstractService {
    private static final String USER_SITE_URI = "/v1/{siteUrl}/users";
    private static final String USER_BLACKLIST_URI = "/v1/{siteUrl}/users/blacklist";
    private static final String USER_BLACKLIST_UUID_URI = "/v1/{siteUrl}/users/blacklist/{uuid}";

    protected UsersBlacklistService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public Status addToBlacklist(String siteUrl, String uuid) {
        return this.addToBlacklist(UserBlacklistAddParams.builder().siteUrl(siteUrl).uuid(uuid).build());
    }

    public Status addToBlacklist(UserBlacklistAddParams params) {
        return this.addToBlacklist(params, RequestOptions.create());
    }

    public Status addToBlacklist(UserBlacklistAddParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(USER_BLACKLIST_UUID_URI).responseClass(Status.class).method(HttpMethod.POST).params(params).options(requestOptions).build());
    }

    public Status removeFromBlacklist(String siteUrl, String uuid) {
        return this.removeFromBlacklist(UserBlacklistRemoveParams.builder().siteUrl(siteUrl).uuid(uuid).build());
    }

    public Status removeFromBlacklist(UserBlacklistRemoveParams params) {
        return this.removeFromBlacklist(params, RequestOptions.create());
    }

    public Status removeFromBlacklist(UserBlacklistRemoveParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(USER_BLACKLIST_UUID_URI).responseClass(Status.class).method(HttpMethod.DELETE).params(params).options(requestOptions).build());
    }

    public List<UserDto> getBlacklistedUsers(UserBlacklistGetListParams params) {
        return this.getBlacklistedUsers(params, RequestOptions.create());
    }

    public List<UserDto> getBlacklistedUsers(UserBlacklistGetListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(USER_BLACKLIST_URI).responseClass(UserDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }
}

