/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.tag.model;

import io.mambo.sdk.service.common.model.CustomFieldValueDto;
import io.mambo.sdk.service.common.model.interfaces.HasCustomFields;
import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import io.mambo.sdk.service.common.model.interfaces.HasTranslation;
import io.mambo.sdk.service.tag.model.TagTranslationDto;
import io.mambo.sdk.utils.ListUtils;
import io.mambo.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public abstract class AbstractTag
implements HasTranslation,
HasInitializedData,
HasCustomFields {
    protected transient List<String> initializedFields = new ArrayList<String>();
    private String name;
    private String tag;
    private Boolean personalization;
    private Boolean hideInWidgets;
    private Boolean withAnalytics;
    private List<CustomFieldValueDto> customFields;
    private List<TagTranslationDto> translations;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.initializedFields.add("name");
        this.name = name;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.initializedFields.add("tag");
        this.tag = tag;
    }

    public Boolean getPersonalization() {
        return this.personalization;
    }

    public void setPersonalization(Boolean personalization) {
        this.initializedFields.add("personalization");
        this.personalization = personalization;
    }

    public Boolean getHideInWidgets() {
        return this.hideInWidgets;
    }

    public void setHideInWidgets(Boolean hideInWidgets) {
        this.initializedFields.add("hideInWidgets");
        this.hideInWidgets = hideInWidgets;
    }

    public Boolean getWithAnalytics() {
        return this.withAnalytics;
    }

    public void setWithAnalytics(Boolean withAnalytics) {
        this.initializedFields.add("withAnalytics");
        this.withAnalytics = withAnalytics;
    }

    @Override
    public List<CustomFieldValueDto> getCustomFields() {
        return this.customFields;
    }

    @Override
    public void setCustomFields(List<CustomFieldValueDto> customFields) {
        this.initializedFields.add("customFields");
        this.customFields = customFields;
    }

    public List<TagTranslationDto> getTranslations() {
        return this.translations;
    }

    public void setTranslations(List<TagTranslationDto> translations) {
        this.initializedFields.add("translations");
        this.translations = translations;
    }

    public void addTranslation(TagTranslationDto translation) {
        if (this.translations == null) {
            this.initializedFields.add("translations");
            this.translations = new ArrayList<TagTranslationDto>();
        }
        this.translations.add(translation);
    }

    public TagTranslationDto getTranslation(String languageCode) {
        if (ListUtils.isEmpty(this.translations)) {
            return null;
        }
        for (TagTranslationDto translation : this.translations) {
            if (!StringUtils.equals(languageCode, translation.getLanguageCode())) continue;
            return translation;
        }
        return null;
    }

    @Override
    public List<String> getInitializedFields() {
        return this.initializedFields;
    }

    @Generated
    public String toString() {
        return "AbstractTag(initializedFields=" + this.initializedFields + ", name=" + this.name + ", tag=" + this.tag + ", personalization=" + this.personalization + ", hideInWidgets=" + this.hideInWidgets + ", withAnalytics=" + this.withAnalytics + ", customFields=" + this.customFields + ", translations=" + this.translations + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTag)) {
            return false;
        }
        AbstractTag other = (AbstractTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$personalization = this.personalization;
        Boolean other$personalization = other.personalization;
        if (this$personalization == null ? other$personalization != null : !((Object)this$personalization).equals(other$personalization)) {
            return false;
        }
        Boolean this$hideInWidgets = this.hideInWidgets;
        Boolean other$hideInWidgets = other.hideInWidgets;
        if (this$hideInWidgets == null ? other$hideInWidgets != null : !((Object)this$hideInWidgets).equals(other$hideInWidgets)) {
            return false;
        }
        Boolean this$withAnalytics = this.withAnalytics;
        Boolean other$withAnalytics = other.withAnalytics;
        if (this$withAnalytics == null ? other$withAnalytics != null : !((Object)this$withAnalytics).equals(other$withAnalytics)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$tag = this.tag;
        String other$tag = other.tag;
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        List<CustomFieldValueDto> this$customFields = this.customFields;
        List<CustomFieldValueDto> other$customFields = other.customFields;
        if (this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields)) {
            return false;
        }
        List<TagTranslationDto> this$translations = this.translations;
        List<TagTranslationDto> other$translations = other.translations;
        return !(this$translations == null ? other$translations != null : !((Object)this$translations).equals(other$translations));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractTag;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $personalization = this.personalization;
        result = result * 59 + ($personalization == null ? 43 : ((Object)$personalization).hashCode());
        Boolean $hideInWidgets = this.hideInWidgets;
        result = result * 59 + ($hideInWidgets == null ? 43 : ((Object)$hideInWidgets).hashCode());
        Boolean $withAnalytics = this.withAnalytics;
        result = result * 59 + ($withAnalytics == null ? 43 : ((Object)$withAnalytics).hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $tag = this.tag;
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        List<CustomFieldValueDto> $customFields = this.customFields;
        result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
        List<TagTranslationDto> $translations = this.translations;
        result = result * 59 + ($translations == null ? 43 : ((Object)$translations).hashCode());
        return result;
    }
}

