/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.tag;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.data.CustomFieldValueRequestData;
import io.mambo.sdk.service.common.data.DeleteRequestData;
import io.mambo.sdk.service.common.data.FileRequestData;
import io.mambo.sdk.service.common.model.CustomFieldValueDto;
import io.mambo.sdk.service.common.model.response.Status;
import io.mambo.sdk.service.tag.data.TagRequestData;
import io.mambo.sdk.service.tag.model.TagDto;
import io.mambo.sdk.service.tag.param.TagCloneParams;
import io.mambo.sdk.service.tag.param.TagCreateParams;
import io.mambo.sdk.service.tag.param.TagCustomFieldParams;
import io.mambo.sdk.service.tag.param.TagDeleteParams;
import io.mambo.sdk.service.tag.param.TagGetByIdParams;
import io.mambo.sdk.service.tag.param.TagGetListParams;
import io.mambo.sdk.service.tag.param.TagGetParams;
import io.mambo.sdk.service.tag.param.TagUpdateParams;
import java.io.File;
import java.util.List;

public class TagsService
extends AbstractService {
    private static final String TAGS_URI = "/v1/tags";
    private static final String TAGS_ID_URI = "/v1/tags/{tagId}";
    private static final String TAGS_SITE_URI = "/v1/{siteUrl}/tags";
    private static final String TAGS_SITE_TAG_URI = "/v1/{siteUrl}/tags/{tagValue}";
    private static final String TAGS_CLONE_URI = "/v1/tags/{tagId}/clone";
    private static final String TAGS_CUSTOM_URI = "/v1/tags/{tagId}/custom_fields";
    private static final String TAGS_CUSTOM_IMAGE_URI = "/v1/tags/{tagId}/custom_fields/image";

    public TagsService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public TagDto create(String siteUrl, TagRequestData data) {
        return this.create(TagCreateParams.builder().siteUrl(siteUrl).build(), data);
    }

    public TagDto create(String siteUrl, TagRequestData data, RequestOptions requestOptions) {
        return this.create(TagCreateParams.builder().siteUrl(siteUrl).build(), data, requestOptions);
    }

    public TagDto create(TagCreateParams params, TagRequestData data) {
        return this.create(params, data, RequestOptions.create());
    }

    public TagDto create(TagCreateParams params, TagRequestData data, RequestOptions requestOptions) {
        return (TagDto)this.apiClient().request(ApiRequest.builder().apiPath(TAGS_SITE_URI).responseClass(TagDto.class).method(HttpMethod.POST).requestData(data).options(requestOptions).params(params).build());
    }

    public TagDto update(String tagId, TagRequestData data) {
        return this.update(TagUpdateParams.builder().tagId(tagId).build(), data);
    }

    public TagDto update(TagUpdateParams params, TagRequestData data) {
        return this.update(params, data, RequestOptions.create());
    }

    public TagDto update(TagUpdateParams params, TagRequestData data, RequestOptions requestOptions) {
        return (TagDto)this.apiClient().request(ApiRequest.builder().apiPath(TAGS_ID_URI).responseClass(TagDto.class).method(HttpMethod.PUT).requestData(data).options(requestOptions).params(params).build());
    }

    public TagDto clone(String tagId) {
        return this.clone(TagCloneParams.builder().tagId(tagId).build());
    }

    public TagDto clone(TagCloneParams params) {
        return this.clone(params, RequestOptions.create());
    }

    public TagDto clone(TagCloneParams params, RequestOptions requestOptions) {
        return (TagDto)this.apiClient().request(ApiRequest.builder().apiPath(TAGS_CLONE_URI).responseClass(TagDto.class).method(HttpMethod.POST).options(requestOptions).params(params).build());
    }

    public Status delete(String tagId) {
        return this.delete(TagDeleteParams.builder().tagId(tagId).build());
    }

    public Status delete(TagDeleteParams params) {
        return this.delete(params, RequestOptions.create());
    }

    public Status delete(TagDeleteParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(TAGS_ID_URI).responseClass(Status.class).method(HttpMethod.DELETE).options(requestOptions).params(params).build());
    }

    public TagDto get(String siteUrl, String tagTag) {
        return this.get(TagGetParams.builder().siteUrl(siteUrl).tagTag(tagTag).build());
    }

    public TagDto get(TagGetParams params) {
        return this.get(params, RequestOptions.create());
    }

    public TagDto get(TagGetParams params, RequestOptions requestOptions) {
        return (TagDto)this.apiClient().request(ApiRequest.builder().apiPath(TAGS_SITE_TAG_URI).responseClass(TagDto.class).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public TagDto get(String tagId) {
        return this.get(TagGetByIdParams.builder().tagId(tagId).build());
    }

    public TagDto get(TagGetByIdParams params) {
        return this.get(params, RequestOptions.create());
    }

    public TagDto get(TagGetByIdParams params, RequestOptions requestOptions) {
        return (TagDto)this.apiClient().request(ApiRequest.builder().apiPath(TAGS_ID_URI).responseClass(TagDto.class).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public Status deleteTags(DeleteRequestData data) {
        return this.deleteTags(data, RequestOptions.create());
    }

    public Status deleteTags(DeleteRequestData data, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(TAGS_URI).responseClass(Status.class).method(HttpMethod.DELETE).options(requestOptions).requestData(data).build());
    }

    public List<TagDto> getTags(String siteUrl) {
        return this.getTags(TagGetListParams.builder().siteUrl(siteUrl).build());
    }

    public List<TagDto> getTags(TagGetListParams params) {
        return this.getTags(params, RequestOptions.create());
    }

    public List<TagDto> getTags(TagGetListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(TAGS_SITE_URI).responseClass(TagDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public TagDto addCustomFields(String tagId, CustomFieldValueRequestData data) {
        TagCustomFieldParams params = TagCustomFieldParams.builder().tagId(tagId).build();
        return this.modCustomFields(HttpMethod.POST, params, data);
    }

    public TagDto addCustomFields(TagCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.modCustomFields(HttpMethod.POST, params, data);
    }

    public TagDto updateCustomFields(String tagId, CustomFieldValueRequestData data) {
        TagCustomFieldParams params = TagCustomFieldParams.builder().tagId(tagId).build();
        return this.modCustomFields(HttpMethod.PUT, params, data);
    }

    public TagDto updateCustomFields(TagCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.modCustomFields(HttpMethod.PUT, params, data);
    }

    public TagDto deleteCustomFields(String tagId, CustomFieldValueRequestData data) {
        TagCustomFieldParams params = TagCustomFieldParams.builder().tagId(tagId).build();
        return this.modCustomFields(HttpMethod.DELETE, params, data);
    }

    public TagDto deleteCustomFields(TagCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.modCustomFields(HttpMethod.DELETE, params, data);
    }

    private TagDto modCustomFields(HttpMethod method, TagCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.modCustomFields(method, params, data, RequestOptions.create());
    }

    private TagDto modCustomFields(HttpMethod method, TagCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return (TagDto)this.apiClient().request(ApiRequest.builder().apiPath(TAGS_CUSTOM_URI).responseClass(TagDto.class).method(method).params(params).options(requestOptions).requestData(data).build());
    }

    public TagDto addCustomField(String tagId, CustomFieldValueDto data, File image) {
        TagCustomFieldParams params = TagCustomFieldParams.builder().tagId(tagId).build();
        return this.addCustomField(params, data, image);
    }

    public TagDto addCustomField(TagCustomFieldParams params, CustomFieldValueDto data, File image) {
        return this.addCustomField(params, data, image, RequestOptions.create());
    }

    public TagDto addCustomField(TagCustomFieldParams params, CustomFieldValueDto data, File image, RequestOptions requestOptions) {
        return (TagDto)this.apiClient().request(ApiRequest.builder().apiPath(TAGS_CUSTOM_IMAGE_URI).responseClass(TagDto.class).method(HttpMethod.POST).params(params).options(requestOptions).requestData(new FileRequestData(image, data)).build());
    }

    public TagRequestData newTagRequestData() {
        return new TagRequestData();
    }
}

