/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.site.model.authentication;

import io.mambo.sdk.utils.StringUtils;

public enum AuthType {
    DATABASE("database"),
    LDAP("ldap"),
    SAML("saml"),
    JWT("jwt"),
    NOAUTH("noauth");

    private String type;

    private AuthType(String pType) {
        this.type = pType;
    }

    public String value() {
        return this.type;
    }

    public Boolean isDatabase() {
        return this == DATABASE;
    }

    public Boolean isLdap() {
        return this == LDAP;
    }

    public Boolean isSaml() {
        return this == SAML;
    }

    public Boolean isJwt() {
        return this == JWT;
    }

    public Boolean isNoAuth() {
        return this == NOAUTH;
    }

    public static AuthType fromString(String type) {
        if (StringUtils.isEmpty(type)) {
            throw new IllegalArgumentException("AuthType type cannot be empty");
        }
        for (AuthType ps : AuthType.values()) {
            if (!type.equalsIgnoreCase(ps.type)) continue;
            return ps;
        }
        return null;
    }
}

