/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.site;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.data.DeleteRequestData;
import io.mambo.sdk.service.common.model.response.Status;
import io.mambo.sdk.service.site.data.SiteRequestData;
import io.mambo.sdk.service.site.model.SiteDto;
import io.mambo.sdk.service.site.param.SiteCloneParams;
import io.mambo.sdk.service.site.param.SiteDeleteParams;
import io.mambo.sdk.service.site.param.SiteGetParams;
import io.mambo.sdk.service.site.param.SiteUpdateParams;
import java.util.List;

public class SitesService
extends AbstractService {
    private static final String SITES_URI = "/v1/sites";
    private static final String SITES_ID_URI = "/v1/sites/{siteId}";
    private static final String SITES_CLONE_URI = "/v1/sites/{siteId}/clone";

    public SitesService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public SiteDto create(SiteRequestData data) {
        return this.create(data, RequestOptions.create());
    }

    public SiteDto create(SiteRequestData data, RequestOptions requestOptions) {
        return (SiteDto)this.apiClient().request(ApiRequest.builder().apiPath(SITES_URI).responseClass(SiteDto.class).method(HttpMethod.POST).requestData(data).options(requestOptions).build());
    }

    public SiteDto update(String siteId, SiteRequestData data) {
        return this.update(SiteUpdateParams.builder().siteId(siteId).build(), data);
    }

    public SiteDto update(SiteUpdateParams params, SiteRequestData data) {
        return this.update(params, data, RequestOptions.create());
    }

    public SiteDto update(SiteUpdateParams params, SiteRequestData data, RequestOptions requestOptions) {
        return (SiteDto)this.apiClient().request(ApiRequest.builder().apiPath(SITES_ID_URI).responseClass(SiteDto.class).method(HttpMethod.PUT).requestData(data).options(requestOptions).params(params).build());
    }

    public SiteDto clone(String siteId, SiteRequestData data) {
        return this.clone(SiteCloneParams.builder().siteId(siteId).build(), data);
    }

    public SiteDto clone(SiteCloneParams params, SiteRequestData data) {
        return this.clone(params, data, RequestOptions.create());
    }

    public SiteDto clone(SiteCloneParams params, SiteRequestData data, RequestOptions requestOptions) {
        return (SiteDto)this.apiClient().request(ApiRequest.builder().apiPath(SITES_CLONE_URI).responseClass(SiteDto.class).method(HttpMethod.POST).requestData(data).options(requestOptions).params(params).build());
    }

    public Status delete(String siteId) {
        return this.delete(SiteDeleteParams.builder().siteId(siteId).build());
    }

    public Status delete(SiteDeleteParams params) {
        return this.delete(params, RequestOptions.create());
    }

    public Status delete(SiteDeleteParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(SITES_ID_URI).responseClass(Status.class).method(HttpMethod.DELETE).options(requestOptions).params(params).build());
    }

    public SiteDto get(String siteId) {
        return this.get(SiteGetParams.builder().siteId(siteId).build());
    }

    public SiteDto get(SiteGetParams params) {
        return this.get(params, RequestOptions.create());
    }

    public SiteDto get(SiteGetParams params, RequestOptions requestOptions) {
        return (SiteDto)this.apiClient().request(ApiRequest.builder().apiPath(SITES_ID_URI).responseClass(SiteDto.class).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public Status deleteSites(DeleteRequestData data) {
        return this.deleteSites(data, RequestOptions.create());
    }

    public Status deleteSites(DeleteRequestData data, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(SITES_URI).responseClass(Status.class).method(HttpMethod.DELETE).options(requestOptions).requestData(data).build());
    }

    public List<SiteDto> getSites() {
        return this.getSites(RequestOptions.create());
    }

    public List<SiteDto> getSites(RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(SITES_URI).responseClass(SiteDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).build());
    }

    public SiteRequestData newSiteRequestData() {
        return new SiteRequestData();
    }
}

