/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.reward.model;

import io.mambo.sdk.service.common.model.CustomFieldValueDto;
import io.mambo.sdk.service.common.model.PrizeDto;
import io.mambo.sdk.service.common.model.ScarcityDto;
import io.mambo.sdk.service.common.model.interfaces.HasCustomFields;
import io.mambo.sdk.service.common.model.interfaces.HasTranslation;
import io.mambo.sdk.service.common.model.tag.AbstractHasAwardByTagRequestData;
import io.mambo.sdk.service.reward.model.RewardTranslationDto;
import io.mambo.sdk.service.reward.model.UnlockConditionDto;
import io.mambo.sdk.service.reward.model.attributes.RewardAttrs;
import io.mambo.sdk.utils.ListUtils;
import io.mambo.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public abstract class AbstractReward
extends AbstractHasAwardByTagRequestData
implements HasTranslation,
HasCustomFields {
    private String name;
    private String message;
    private String hint;
    private String startDate;
    private String endDate;
    private Boolean active;
    private Boolean hideInWidgets;
    private Boolean multiUnlock;
    private Long hasAtLeast;
    private Long countLimit;
    private RewardAttrs attrs;
    private PrizeDto prizes;
    private ScarcityDto scarcity;
    private List<UnlockConditionDto> unlockConditions;
    private List<CustomFieldValueDto> customFields;
    private List<RewardTranslationDto> translations;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.initializedFields.add("name");
        this.name = name;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.initializedFields.add("active");
        this.active = active;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.initializedFields.add("message");
        this.message = message;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.initializedFields.add("hint");
        this.hint = hint;
    }

    public Boolean getHideInWidgets() {
        return this.hideInWidgets;
    }

    public void setHideInWidgets(Boolean hideInWidgets) {
        this.initializedFields.add("hideInWidgets");
        this.hideInWidgets = hideInWidgets;
    }

    public PrizeDto getPrizes() {
        return this.prizes;
    }

    public void setPrizes(PrizeDto prizes) {
        this.initializedFields.add("prizes");
        this.prizes = prizes;
    }

    public Boolean getMultiUnlock() {
        return this.multiUnlock;
    }

    public void setMultiUnlock(Boolean multiUnlock) {
        this.initializedFields.add("multiUnlock");
        this.multiUnlock = multiUnlock;
    }

    public Long getCountLimit() {
        return this.countLimit;
    }

    public void setCountLimit(Long countLimit) {
        this.initializedFields.add("countLimit");
        this.countLimit = countLimit;
    }

    public ScarcityDto getScarcity() {
        return this.scarcity;
    }

    public void setScarcity(ScarcityDto scarcity) {
        this.initializedFields.add("scarcity");
        this.scarcity = scarcity;
    }

    public Long getHasAtLeast() {
        return this.hasAtLeast;
    }

    public void setHasAtLeast(Long hasAtLeast) {
        this.initializedFields.add("hasAtLeast");
        this.hasAtLeast = hasAtLeast;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.initializedFields.add("startDate");
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.initializedFields.add("endDate");
        this.endDate = endDate;
    }

    public RewardAttrs getAttrs() {
        return this.attrs;
    }

    public void setAttrs(RewardAttrs attrs) {
        this.initializedFields.add("attrs");
        this.attrs = attrs;
    }

    public Boolean isLevel() {
        if (this.attrs == null) {
            return false;
        }
        return RewardType.LEVEL.isValue(this.attrs.getType());
    }

    public Boolean isAchievement() {
        if (this.attrs == null) {
            return false;
        }
        return RewardType.ACHIEVEMENT.isValue(this.attrs.getType());
    }

    public Boolean isMission() {
        if (this.attrs == null) {
            return false;
        }
        return RewardType.MISSION.isValue(this.attrs.getType());
    }

    public Boolean isGift() {
        if (this.attrs == null) {
            return false;
        }
        return RewardType.GIFT.isValue(this.attrs.getType());
    }

    public List<UnlockConditionDto> getUnlockConditions() {
        return this.unlockConditions;
    }

    public void setUnlockConditions(List<UnlockConditionDto> unlockConditions) {
        this.initializedFields.add("unlockConditions");
        this.unlockConditions = unlockConditions;
    }

    public void addUnlockCondition(UnlockConditionDto unlockCondition) {
        this.initializedFields.add("unlockConditions");
        if (this.unlockConditions == null) {
            this.unlockConditions = new ArrayList<UnlockConditionDto>();
        }
        this.unlockConditions.add(unlockCondition);
    }

    @Override
    public List<CustomFieldValueDto> getCustomFields() {
        return this.customFields;
    }

    @Override
    public void setCustomFields(List<CustomFieldValueDto> customFields) {
        this.initializedFields.add("customFields");
        this.customFields = customFields;
    }

    public List<RewardTranslationDto> getTranslations() {
        return this.translations;
    }

    public void setTranslations(List<RewardTranslationDto> translations) {
        this.initializedFields.add("translations");
        this.translations = translations;
    }

    public void addTranslation(RewardTranslationDto translation) {
        if (this.translations == null) {
            this.initializedFields.add("translations");
            this.translations = new ArrayList<RewardTranslationDto>();
        }
        this.translations.add(translation);
    }

    public RewardTranslationDto getTranslation(String languageCode) {
        if (ListUtils.isEmpty(this.translations)) {
            return null;
        }
        for (RewardTranslationDto translation : this.translations) {
            if (!StringUtils.equals(languageCode, translation.getLanguageCode())) continue;
            return translation;
        }
        return null;
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractReward(super=" + super.toString() + ", name=" + this.name + ", message=" + this.message + ", hint=" + this.hint + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", active=" + this.active + ", hideInWidgets=" + this.hideInWidgets + ", multiUnlock=" + this.multiUnlock + ", hasAtLeast=" + this.hasAtLeast + ", countLimit=" + this.countLimit + ", attrs=" + this.attrs + ", prizes=" + this.prizes + ", scarcity=" + this.scarcity + ", unlockConditions=" + this.unlockConditions + ", customFields=" + this.customFields + ", translations=" + this.translations + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractReward)) {
            return false;
        }
        AbstractReward other = (AbstractReward)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$active = this.active;
        Boolean other$active = other.active;
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Boolean this$hideInWidgets = this.hideInWidgets;
        Boolean other$hideInWidgets = other.hideInWidgets;
        if (this$hideInWidgets == null ? other$hideInWidgets != null : !((Object)this$hideInWidgets).equals(other$hideInWidgets)) {
            return false;
        }
        Boolean this$multiUnlock = this.multiUnlock;
        Boolean other$multiUnlock = other.multiUnlock;
        if (this$multiUnlock == null ? other$multiUnlock != null : !((Object)this$multiUnlock).equals(other$multiUnlock)) {
            return false;
        }
        Long this$hasAtLeast = this.hasAtLeast;
        Long other$hasAtLeast = other.hasAtLeast;
        if (this$hasAtLeast == null ? other$hasAtLeast != null : !((Object)this$hasAtLeast).equals(other$hasAtLeast)) {
            return false;
        }
        Long this$countLimit = this.countLimit;
        Long other$countLimit = other.countLimit;
        if (this$countLimit == null ? other$countLimit != null : !((Object)this$countLimit).equals(other$countLimit)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$message = this.message;
        String other$message = other.message;
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$hint = this.hint;
        String other$hint = other.hint;
        if (this$hint == null ? other$hint != null : !this$hint.equals(other$hint)) {
            return false;
        }
        String this$startDate = this.startDate;
        String other$startDate = other.startDate;
        if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) {
            return false;
        }
        String this$endDate = this.endDate;
        String other$endDate = other.endDate;
        if (this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate)) {
            return false;
        }
        RewardAttrs this$attrs = this.attrs;
        RewardAttrs other$attrs = other.attrs;
        if (this$attrs == null ? other$attrs != null : !this$attrs.equals(other$attrs)) {
            return false;
        }
        PrizeDto this$prizes = this.prizes;
        PrizeDto other$prizes = other.prizes;
        if (this$prizes == null ? other$prizes != null : !((Object)this$prizes).equals(other$prizes)) {
            return false;
        }
        ScarcityDto this$scarcity = this.scarcity;
        ScarcityDto other$scarcity = other.scarcity;
        if (this$scarcity == null ? other$scarcity != null : !((Object)this$scarcity).equals(other$scarcity)) {
            return false;
        }
        List<UnlockConditionDto> this$unlockConditions = this.unlockConditions;
        List<UnlockConditionDto> other$unlockConditions = other.unlockConditions;
        if (this$unlockConditions == null ? other$unlockConditions != null : !((Object)this$unlockConditions).equals(other$unlockConditions)) {
            return false;
        }
        List<CustomFieldValueDto> this$customFields = this.customFields;
        List<CustomFieldValueDto> other$customFields = other.customFields;
        if (this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields)) {
            return false;
        }
        List<RewardTranslationDto> this$translations = this.translations;
        List<RewardTranslationDto> other$translations = other.translations;
        return !(this$translations == null ? other$translations != null : !((Object)this$translations).equals(other$translations));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractReward;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $active = this.active;
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Boolean $hideInWidgets = this.hideInWidgets;
        result = result * 59 + ($hideInWidgets == null ? 43 : ((Object)$hideInWidgets).hashCode());
        Boolean $multiUnlock = this.multiUnlock;
        result = result * 59 + ($multiUnlock == null ? 43 : ((Object)$multiUnlock).hashCode());
        Long $hasAtLeast = this.hasAtLeast;
        result = result * 59 + ($hasAtLeast == null ? 43 : ((Object)$hasAtLeast).hashCode());
        Long $countLimit = this.countLimit;
        result = result * 59 + ($countLimit == null ? 43 : ((Object)$countLimit).hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $message = this.message;
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $hint = this.hint;
        result = result * 59 + ($hint == null ? 43 : $hint.hashCode());
        String $startDate = this.startDate;
        result = result * 59 + ($startDate == null ? 43 : $startDate.hashCode());
        String $endDate = this.endDate;
        result = result * 59 + ($endDate == null ? 43 : $endDate.hashCode());
        RewardAttrs $attrs = this.attrs;
        result = result * 59 + ($attrs == null ? 43 : $attrs.hashCode());
        PrizeDto $prizes = this.prizes;
        result = result * 59 + ($prizes == null ? 43 : ((Object)$prizes).hashCode());
        ScarcityDto $scarcity = this.scarcity;
        result = result * 59 + ($scarcity == null ? 43 : ((Object)$scarcity).hashCode());
        List<UnlockConditionDto> $unlockConditions = this.unlockConditions;
        result = result * 59 + ($unlockConditions == null ? 43 : ((Object)$unlockConditions).hashCode());
        List<CustomFieldValueDto> $customFields = this.customFields;
        result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
        List<RewardTranslationDto> $translations = this.translations;
        result = result * 59 + ($translations == null ? 43 : ((Object)$translations).hashCode());
        return result;
    }

    public static enum RewardType {
        LEVEL("level"),
        ACHIEVEMENT("achievement"),
        MISSION("mission"),
        GIFT("gift");

        private String value;

        private RewardType(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public Boolean isValue(String other) {
            return StringUtils.equals(this.value, other);
        }
    }
}

