/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.reward;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.data.CustomFieldValueRequestData;
import io.mambo.sdk.service.common.data.DeleteRequestData;
import io.mambo.sdk.service.common.data.FileRequestData;
import io.mambo.sdk.service.common.model.CustomFieldValueDto;
import io.mambo.sdk.service.common.model.response.Status;
import io.mambo.sdk.service.reward.data.RewardRequestData;
import io.mambo.sdk.service.reward.model.RewardDto;
import io.mambo.sdk.service.reward.param.RewardCloneParams;
import io.mambo.sdk.service.reward.param.RewardCreateParams;
import io.mambo.sdk.service.reward.param.RewardCustomFieldParams;
import io.mambo.sdk.service.reward.param.RewardDeleteParams;
import io.mambo.sdk.service.reward.param.RewardGetAchievementListParams;
import io.mambo.sdk.service.reward.param.RewardGetGiftListParams;
import io.mambo.sdk.service.reward.param.RewardGetLevelListParams;
import io.mambo.sdk.service.reward.param.RewardGetListParams;
import io.mambo.sdk.service.reward.param.RewardGetMissionListParams;
import io.mambo.sdk.service.reward.param.RewardGetParams;
import io.mambo.sdk.service.reward.param.RewardUpdateParams;
import io.mambo.sdk.service.reward.param.RewardUploadParams;
import java.io.File;
import java.util.List;

public class RewardsService
extends AbstractService {
    private static final String REWARDS_URI = "/v1/rewards";
    private static final String REWARDS_ID_URI = "/v1/rewards/{rewardId}";
    private static final String REWARDS_IMAGE_URI = "/v1/rewards/{rewardId}/image";
    private static final String REWARDS_CLONE_URI = "/v1/rewards/{rewardId}/clone";
    private static final String REWARDS_CUSTOM_URI = "/v1/rewards/{rewardId}/custom_fields";
    private static final String REWARDS_CUSTOM_IMAGE_URI = "/v1/rewards/{rewardId}/custom_fields/image";
    private static final String REWARDS_SITE_URI = "/v1/{siteUrl}/rewards";
    private static final String ACHIEVEMENTS_SITE_URI = "/v1/{siteUrl}/rewards/achievements";
    private static final String LEVELS_SITE_URI = "/v1/{siteUrl}/rewards/levels";
    private static final String MISSIONS_SITE_URI = "/v1/{siteUrl}/rewards/missions";
    private static final String GIFTS_SITE_URI = "/v1/{siteUrl}/rewards/gifts";

    public RewardsService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public RewardDto create(String siteUrl, RewardRequestData data) {
        return this.create(RewardCreateParams.builder().siteUrl(siteUrl).build(), data);
    }

    public RewardDto create(String siteUrl, RewardRequestData data, RequestOptions requestOptions) {
        RewardCreateParams params = RewardCreateParams.builder().siteUrl(siteUrl).build();
        return this.create(params, data, requestOptions);
    }

    public RewardDto create(RewardCreateParams params, RewardRequestData data) {
        return this.create(params, data, RequestOptions.create());
    }

    public RewardDto create(RewardCreateParams params, RewardRequestData data, RequestOptions requestOptions) {
        return (RewardDto)this.apiClient().request(ApiRequest.builder().apiPath(REWARDS_SITE_URI).responseClass(RewardDto.class).method(HttpMethod.POST).requestData(data).options(requestOptions).params(params).build());
    }

    public RewardDto update(String rewardId, RewardRequestData data) {
        return this.update(RewardUpdateParams.builder().rewardId(rewardId).build(), data);
    }

    public RewardDto update(RewardUpdateParams params, RewardRequestData data) {
        return this.update(params, data, RequestOptions.create());
    }

    public RewardDto update(RewardUpdateParams params, RewardRequestData data, RequestOptions requestOptions) {
        return (RewardDto)this.apiClient().request(ApiRequest.builder().apiPath(REWARDS_ID_URI).responseClass(RewardDto.class).method(HttpMethod.PUT).requestData(data).options(requestOptions).params(params).build());
    }

    public RewardDto uploadImage(String rewardId, File image) {
        return this.uploadImage(RewardUploadParams.builder().rewardId(rewardId).build(), image);
    }

    public RewardDto uploadImage(RewardUploadParams params, File image) {
        return this.uploadImage(params, image, RequestOptions.create());
    }

    public RewardDto uploadImage(RewardUploadParams params, File image, RequestOptions requestOptions) {
        return (RewardDto)this.apiClient().request(ApiRequest.builder().apiPath(REWARDS_IMAGE_URI).responseClass(RewardDto.class).method(HttpMethod.POST).requestData(new FileRequestData(image)).options(requestOptions).params(params).build());
    }

    public RewardDto clone(String rewardId) {
        return this.clone(RewardCloneParams.builder().rewardId(rewardId).build());
    }

    public RewardDto clone(RewardCloneParams params) {
        return this.clone(params, RequestOptions.create());
    }

    public RewardDto clone(RewardCloneParams params, RequestOptions requestOptions) {
        return (RewardDto)this.apiClient().request(ApiRequest.builder().apiPath(REWARDS_CLONE_URI).responseClass(RewardDto.class).method(HttpMethod.POST).options(requestOptions).params(params).build());
    }

    public Status delete(String rewardId) {
        return this.delete(RewardDeleteParams.builder().rewardId(rewardId).build());
    }

    public Status delete(RewardDeleteParams params) {
        return this.delete(params, RequestOptions.create());
    }

    public Status delete(RewardDeleteParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(REWARDS_ID_URI).responseClass(Status.class).method(HttpMethod.DELETE).options(requestOptions).params(params).build());
    }

    public RewardDto get(String rewardId) {
        return this.get(RewardGetParams.builder().rewardId(rewardId).build());
    }

    public RewardDto get(RewardGetParams params) {
        return this.get(params, RequestOptions.create());
    }

    public RewardDto get(RewardGetParams params, RequestOptions requestOptions) {
        return (RewardDto)this.apiClient().request(ApiRequest.builder().apiPath(REWARDS_ID_URI).responseClass(RewardDto.class).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public Status deleteRewards(DeleteRequestData data) {
        return this.deleteRewards(data, RequestOptions.create());
    }

    public Status deleteRewards(DeleteRequestData data, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(REWARDS_URI).responseClass(Status.class).method(HttpMethod.DELETE).requestData(data).options(requestOptions).build());
    }

    public List<RewardDto> getRewards(String siteUrl) {
        return this.getRewards(RewardGetListParams.builder().siteUrl(siteUrl).build());
    }

    public List<RewardDto> getRewards(RewardGetListParams params) {
        return this.getRewards(params, RequestOptions.create());
    }

    public List<RewardDto> getRewards(RewardGetListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(REWARDS_SITE_URI).responseClass(RewardDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public List<RewardDto> getAchievements(String siteUrl) {
        return this.getAchievements(RewardGetAchievementListParams.builder().siteUrl(siteUrl).build());
    }

    public List<RewardDto> getAchievements(RewardGetAchievementListParams params) {
        return this.getAchievements(params, RequestOptions.create());
    }

    public List<RewardDto> getAchievements(RewardGetAchievementListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(ACHIEVEMENTS_SITE_URI).responseClass(RewardDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public List<RewardDto> getLevels(String siteUrl) {
        return this.getLevels(RewardGetLevelListParams.builder().siteUrl(siteUrl).build());
    }

    public List<RewardDto> getLevels(RewardGetLevelListParams params) {
        return this.getLevels(params, RequestOptions.create());
    }

    public List<RewardDto> getLevels(RewardGetLevelListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(LEVELS_SITE_URI).responseClass(RewardDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public List<RewardDto> getMissions(String siteUrl) {
        return this.getMissions(RewardGetMissionListParams.builder().siteUrl(siteUrl).build());
    }

    public List<RewardDto> getMissions(RewardGetMissionListParams params) {
        return this.getMissions(params, RequestOptions.create());
    }

    public List<RewardDto> getMissions(RewardGetMissionListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(MISSIONS_SITE_URI).responseClass(RewardDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public List<RewardDto> getGifts(String siteUrl) {
        return this.getGifts(RewardGetGiftListParams.builder().siteUrl(siteUrl).build());
    }

    public List<RewardDto> getGifts(RewardGetGiftListParams params) {
        return this.getGifts(params, RequestOptions.create());
    }

    public List<RewardDto> getGifts(RewardGetGiftListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(GIFTS_SITE_URI).responseClass(RewardDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public RewardDto addCustomFields(String rewardId, CustomFieldValueRequestData data) {
        RewardCustomFieldParams params = RewardCustomFieldParams.builder().rewardId(rewardId).build();
        return this.addCustomFields(params, data);
    }

    public RewardDto addCustomFields(RewardCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.addCustomFields(params, data, RequestOptions.create());
    }

    public RewardDto addCustomFields(RewardCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return this.modCustomFields(HttpMethod.POST, params, data, requestOptions);
    }

    public RewardDto updateCustomFields(String rewardId, CustomFieldValueRequestData data) {
        RewardCustomFieldParams params = RewardCustomFieldParams.builder().rewardId(rewardId).build();
        return this.updateCustomFields(params, data);
    }

    public RewardDto updateCustomFields(RewardCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.updateCustomFields(params, data, RequestOptions.create());
    }

    public RewardDto updateCustomFields(RewardCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return this.modCustomFields(HttpMethod.PUT, params, data, requestOptions);
    }

    public RewardDto deleteCustomFields(String rewardId, CustomFieldValueRequestData data) {
        RewardCustomFieldParams params = RewardCustomFieldParams.builder().rewardId(rewardId).build();
        return this.deleteCustomFields(params, data);
    }

    public RewardDto deleteCustomFields(RewardCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.deleteCustomFields(params, data, RequestOptions.create());
    }

    public RewardDto deleteCustomFields(RewardCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return this.modCustomFields(HttpMethod.DELETE, params, data, requestOptions);
    }

    private RewardDto modCustomFields(HttpMethod method, RewardCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return (RewardDto)this.apiClient().request(ApiRequest.builder().apiPath(REWARDS_CUSTOM_URI).responseClass(RewardDto.class).method(method).params(params).options(requestOptions).requestData(data).build());
    }

    public RewardDto addCustomField(String rewardId, CustomFieldValueDto data, File image) {
        RewardCustomFieldParams params = RewardCustomFieldParams.builder().rewardId(rewardId).build();
        return this.addCustomField(params, data, image);
    }

    public RewardDto addCustomField(RewardCustomFieldParams params, CustomFieldValueDto data, File image) {
        return this.addCustomField(params, data, image, RequestOptions.create());
    }

    public RewardDto addCustomField(RewardCustomFieldParams params, CustomFieldValueDto data, File image, RequestOptions requestOptions) {
        return (RewardDto)this.apiClient().request(ApiRequest.builder().apiPath(REWARDS_CUSTOM_IMAGE_URI).responseClass(RewardDto.class).method(HttpMethod.POST).params(params).options(requestOptions).requestData(new FileRequestData(image, data)).build());
    }

    public RewardRequestData newRewardRequestData() {
        return new RewardRequestData();
    }
}

