/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.point.param;

import io.mambo.sdk.service.common.param.AbstractServiceParamsBuilder;
import io.mambo.sdk.service.common.param.ServiceParams;
import io.mambo.sdk.utils.Multimap;
import io.mambo.sdk.utils.Preconditions;

public class PointWalletsGetListParams
implements ServiceParams {
    private Multimap<String, String> params = new Multimap();

    private PointWalletsGetListParams(Builder builder) {
        this.params = builder.params();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Multimap<String, String> asMap() {
        return this.params;
    }

    public static class Builder
    extends AbstractServiceParamsBuilder<Builder> {
        public Builder siteUrl(String siteUrl) {
            Preconditions.checkNotNull(siteUrl, "siteUrl must not be null");
            this.params.put("siteUrl", siteUrl);
            return this;
        }

        public Builder pageSize(int pageSize) {
            this.params.put("pageSize", String.valueOf(pageSize));
            return this;
        }

        public Builder pageAfter(String pageAfter) {
            this.params.put("pageAfter", pageAfter);
            return this;
        }

        public Builder pageBefore(String pageBefore) {
            this.params.put("pageBefore", pageBefore);
            return this;
        }

        public PointWalletsGetListParams build() {
            Preconditions.checkContainsKey(this.params, "siteUrl", "siteUrl must not be null");
            return new PointWalletsGetListParams(this);
        }

        private Multimap<String, String> params() {
            return this.params;
        }
    }
}

