/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.point.param;

import io.mambo.sdk.service.common.param.AbstractServiceParamsBuilder;
import io.mambo.sdk.service.common.param.ServiceParams;
import io.mambo.sdk.utils.Multimap;
import io.mambo.sdk.utils.Preconditions;

public class PointTransactionGetByActivityIdParams
implements ServiceParams {
    private Multimap<String, String> params = new Multimap();

    private PointTransactionGetByActivityIdParams(Builder builder) {
        this.params = builder.params();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Multimap<String, String> asMap() {
        return this.params;
    }

    public static class Builder
    extends AbstractServiceParamsBuilder<Builder> {
        private static final String ACTIVITY_ID_MUST_NOT_BE_NULL = "activityId must not be null";

        public Builder activityId(String activityId) {
            Preconditions.checkNotNull(activityId, ACTIVITY_ID_MUST_NOT_BE_NULL);
            this.params.put("activityId", activityId);
            return this;
        }

        public Builder pointId(String pointId) {
            this.params.put("pointId", pointId);
            return this;
        }

        public Builder userId(String userId) {
            this.params.put("userId", userId);
            return this;
        }

        public Builder transactionType(String transactionType) {
            this.params.put("transactionType", transactionType);
            return this;
        }

        public Builder status(String status) {
            this.params.put("status", status);
            return this;
        }

        public Builder withPoints(boolean withPoints) {
            this.params.put("withPoints", String.valueOf(withPoints));
            return this;
        }

        public Builder withUsers(boolean withUsers) {
            this.params.put("withUsers", String.valueOf(withUsers));
            return this;
        }

        public PointTransactionGetByActivityIdParams build() {
            Preconditions.checkContainsKey(this.params, "activityId", ACTIVITY_ID_MUST_NOT_BE_NULL);
            return new PointTransactionGetByActivityIdParams(this);
        }

        private Multimap<String, String> params() {
            return this.params;
        }
    }
}

