/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.point;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.data.CustomFieldValueRequestData;
import io.mambo.sdk.service.common.data.DeleteRequestData;
import io.mambo.sdk.service.common.data.FileRequestData;
import io.mambo.sdk.service.common.model.CustomFieldValueDto;
import io.mambo.sdk.service.common.model.response.ResponseEntity;
import io.mambo.sdk.service.common.model.response.Status;
import io.mambo.sdk.service.point.data.PointRequestData;
import io.mambo.sdk.service.point.model.PointDto;
import io.mambo.sdk.service.point.model.PointTransactionDto;
import io.mambo.sdk.service.point.model.PointWalletDto;
import io.mambo.sdk.service.point.param.PointCloneParams;
import io.mambo.sdk.service.point.param.PointCreateParams;
import io.mambo.sdk.service.point.param.PointCustomFieldParams;
import io.mambo.sdk.service.point.param.PointDeleteParams;
import io.mambo.sdk.service.point.param.PointGetListParams;
import io.mambo.sdk.service.point.param.PointGetParams;
import io.mambo.sdk.service.point.param.PointTransactionGetByActivityIdParams;
import io.mambo.sdk.service.point.param.PointUpdateParams;
import io.mambo.sdk.service.point.param.PointUploadParams;
import io.mambo.sdk.service.point.param.PointWalletsGetListParams;
import java.io.File;
import java.util.List;

public class PointsService
extends AbstractService {
    private static final String POINTS_URI = "/v1/points";
    private static final String POINTS_ID_URI = "/v1/points/{pointId}";
    private static final String POINTS_IMAGE_URI = "/v1/points/{pointId}/image";
    private static final String POINTS_CLONE_URI = "/v1/points/{pointId}/clone";
    private static final String POINTS_CUSTOM_URI = "/v1/points/{pointId}/custom_fields";
    private static final String POINTS_CUSTOM_IMAGE_URI = "/v1/points/{pointId}/custom_fields/image";
    private static final String POINTS_TRANSACTIONS_BY_ACTIVITY_URI = "/v1/points/{pointId}/transactions/{activityId}";
    private static final String POINTS_SITE_URI = "/v1/{siteUrl}/points";
    private static final String POINTS_SITE_WALLETS_URI = "/v1/{siteUrl}/points/wallets";

    public PointsService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public PointDto create(String siteUrl, PointRequestData data) {
        return this.create(siteUrl, data, RequestOptions.create());
    }

    public PointDto create(String siteUrl, PointRequestData data, RequestOptions requestOptions) {
        return this.create(PointCreateParams.builder().siteUrl(siteUrl).build(), data, requestOptions);
    }

    public PointDto create(PointCreateParams params, PointRequestData data) {
        return this.create(params, data, RequestOptions.create());
    }

    public PointDto create(PointCreateParams params, PointRequestData data, RequestOptions requestOptions) {
        return (PointDto)this.apiClient().request(ApiRequest.builder().apiPath(POINTS_SITE_URI).responseClass(PointDto.class).method(HttpMethod.POST).requestData(data).options(requestOptions).params(params).build());
    }

    public PointDto update(String pointId, PointRequestData data) {
        return this.update(PointUpdateParams.builder().pointId(pointId).build(), data, RequestOptions.create());
    }

    public PointDto update(String pointId, PointRequestData data, RequestOptions requestOptions) {
        return this.update(PointUpdateParams.builder().pointId(pointId).build(), data, requestOptions);
    }

    public PointDto update(PointUpdateParams params, PointRequestData data) {
        return this.update(params, data, RequestOptions.create());
    }

    public PointDto update(PointUpdateParams params, PointRequestData data, RequestOptions requestOptions) {
        return (PointDto)this.apiClient().request(ApiRequest.builder().apiPath(POINTS_ID_URI).responseClass(PointDto.class).method(HttpMethod.PUT).requestData(data).options(requestOptions).params(params).build());
    }

    public PointDto uploadImage(String pointId, File image) {
        return this.uploadImage(PointUploadParams.builder().pointId(pointId).build(), image, RequestOptions.create());
    }

    public PointDto uploadImage(String pointId, File image, RequestOptions requestOptions) {
        return this.uploadImage(PointUploadParams.builder().pointId(pointId).build(), image, requestOptions);
    }

    public PointDto uploadImage(PointUploadParams params, File image) {
        return this.uploadImage(params, image, RequestOptions.create());
    }

    public PointDto uploadImage(PointUploadParams params, File image, RequestOptions requestOptions) {
        return (PointDto)this.apiClient().request(ApiRequest.builder().apiPath(POINTS_IMAGE_URI).responseClass(PointDto.class).method(HttpMethod.POST).requestData(new FileRequestData(image)).options(requestOptions).params(params).build());
    }

    public PointDto clone(String pointId) {
        return this.clone(PointCloneParams.builder().pointId(pointId).build(), RequestOptions.create());
    }

    public PointDto clone(String pointId, RequestOptions requestOptions) {
        return this.clone(PointCloneParams.builder().pointId(pointId).build(), requestOptions);
    }

    public PointDto clone(PointCloneParams params) {
        return this.clone(params, RequestOptions.create());
    }

    public PointDto clone(PointCloneParams params, RequestOptions requestOptions) {
        return (PointDto)this.apiClient().request(ApiRequest.builder().apiPath(POINTS_CLONE_URI).responseClass(PointDto.class).method(HttpMethod.POST).options(requestOptions).params(params).build());
    }

    public Status delete(String pointId) {
        return this.delete(PointDeleteParams.builder().pointId(pointId).build(), RequestOptions.create());
    }

    public Status delete(String pointId, RequestOptions requestOptions) {
        return this.delete(PointDeleteParams.builder().pointId(pointId).build(), requestOptions);
    }

    public Status delete(PointDeleteParams params) {
        return this.delete(params, RequestOptions.create());
    }

    public Status delete(PointDeleteParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(POINTS_ID_URI).responseClass(Status.class).method(HttpMethod.DELETE).options(requestOptions).params(params).build());
    }

    public PointDto get(String pointId) {
        return this.get(PointGetParams.builder().pointId(pointId).build(), RequestOptions.create());
    }

    public PointDto get(String pointId, RequestOptions requestOptions) {
        return this.get(PointGetParams.builder().pointId(pointId).build(), requestOptions);
    }

    public PointDto get(PointGetParams params) {
        return this.get(params, RequestOptions.create());
    }

    public PointDto get(PointGetParams params, RequestOptions requestOptions) {
        return (PointDto)this.apiClient().request(ApiRequest.builder().apiPath(POINTS_ID_URI).responseClass(PointDto.class).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public Status deletePoints(DeleteRequestData data) {
        return this.deletePoints(data, RequestOptions.create());
    }

    public Status deletePoints(DeleteRequestData data, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(POINTS_URI).responseClass(Status.class).method(HttpMethod.DELETE).options(requestOptions).requestData(data).build());
    }

    public List<PointDto> getPoints(String siteUrl) {
        return this.getPoints(PointGetListParams.builder().siteUrl(siteUrl).build(), RequestOptions.create());
    }

    public List<PointDto> getPoints(PointGetListParams params) {
        return this.getPoints(params, RequestOptions.create());
    }

    public List<PointDto> getPoints(PointGetListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(POINTS_SITE_URI).responseClass(PointDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public ResponseEntity<PointWalletDto> getPointWallets(String siteUrl) {
        return this.getPointWallets(PointWalletsGetListParams.builder().siteUrl(siteUrl).build(), RequestOptions.create());
    }

    public ResponseEntity<PointWalletDto> getPointWallets(PointWalletsGetListParams params) {
        return this.getPointWallets(params, RequestOptions.create());
    }

    public ResponseEntity<PointWalletDto> getPointWallets(PointWalletsGetListParams params, RequestOptions requestOptions) {
        return (ResponseEntity)this.apiClient().request(ApiRequest.builder().apiPath(POINTS_SITE_WALLETS_URI).responseClass(PointWalletDto.class).responseType(ResponseType.RESPONSE_ENTITY).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public List<PointTransactionDto> getTransactionsByActivityId(String activityId) {
        return this.getTransactionsByActivityId(PointTransactionGetByActivityIdParams.builder().activityId(activityId).build());
    }

    public List<PointTransactionDto> getTransactionsByActivityId(PointTransactionGetByActivityIdParams params) {
        return this.getTransactionsByActivityId(params, RequestOptions.create());
    }

    public List<PointTransactionDto> getTransactionsByActivityId(PointTransactionGetByActivityIdParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(POINTS_TRANSACTIONS_BY_ACTIVITY_URI).responseClass(PointTransactionDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public PointDto addCustomFields(String pointId, CustomFieldValueRequestData data) {
        PointCustomFieldParams params = PointCustomFieldParams.builder().pointId(pointId).build();
        return this.modCustomFields(HttpMethod.POST, params, data, RequestOptions.create());
    }

    public PointDto addCustomFields(PointCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.modCustomFields(HttpMethod.POST, params, data, RequestOptions.create());
    }

    public PointDto updateCustomFields(String pointId, CustomFieldValueRequestData data) {
        PointCustomFieldParams params = PointCustomFieldParams.builder().pointId(pointId).build();
        return this.modCustomFields(HttpMethod.PUT, params, data, RequestOptions.create());
    }

    public PointDto updateCustomFields(PointCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.modCustomFields(HttpMethod.PUT, params, data, RequestOptions.create());
    }

    public PointDto deleteCustomFields(String pointId, CustomFieldValueRequestData data) {
        PointCustomFieldParams params = PointCustomFieldParams.builder().pointId(pointId).build();
        return this.modCustomFields(HttpMethod.DELETE, params, data, RequestOptions.create());
    }

    public PointDto deleteCustomFields(PointCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.modCustomFields(HttpMethod.DELETE, params, data, RequestOptions.create());
    }

    private PointDto modCustomFields(HttpMethod method, PointCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return (PointDto)this.apiClient().request(ApiRequest.builder().apiPath(POINTS_CUSTOM_URI).responseClass(PointDto.class).method(method).params(params).options(requestOptions).requestData(data).build());
    }

    public PointDto addCustomField(String pointId, CustomFieldValueDto data, File image) {
        return this.addCustomField(pointId, data, image, RequestOptions.create());
    }

    public PointDto addCustomField(String pointId, CustomFieldValueDto data, File image, RequestOptions requestOptions) {
        PointCustomFieldParams params = PointCustomFieldParams.builder().pointId(pointId).build();
        return this.addCustomField(params, data, image, requestOptions);
    }

    public PointDto addCustomField(PointCustomFieldParams params, CustomFieldValueDto data, File image) {
        return this.addCustomField(params, data, image, RequestOptions.create());
    }

    public PointDto addCustomField(PointCustomFieldParams params, CustomFieldValueDto data, File image, RequestOptions requestOptions) {
        return (PointDto)this.apiClient().request(ApiRequest.builder().apiPath(POINTS_CUSTOM_IMAGE_URI).responseClass(PointDto.class).method(HttpMethod.POST).params(params).options(requestOptions).requestData(new FileRequestData(image, data)).build());
    }

    public PointRequestData newPointRequestData() {
        return new PointRequestData();
    }
}

