/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.notification;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.model.response.Status;
import io.mambo.sdk.service.notification.data.ClearNotificationsRequestData;
import io.mambo.sdk.service.notification.model.NotificationDto;
import io.mambo.sdk.service.notification.param.NotificationClearParams;
import io.mambo.sdk.service.notification.param.NotificationGetByActivityIdParams;
import io.mambo.sdk.service.notification.param.NotificationGetListParams;
import io.mambo.sdk.service.notification.param.NotificationGetParams;
import java.util.List;

public class NotificationsService
extends AbstractService {
    private static final String NOTIFICATIONS_URI = "/v1/notifications";
    private static final String NOTIFICATIONS_ACTIVITY_ID_URI = "/v1/notifications/activity/{activityId}";
    private static final String NOTIFICATIONS_ID_URI = "/v1/notifications/{notificationId}";
    private static final String CLEAR_NOTIFICATIONS_ID_URI = "/v1/notifications/{notificationId}/clear";
    private static final String CLEAR_NOTIFICATIONS_URI = "/v1/notifications/clear";
    private static final String NOTIFICATIONS_SITE_URI = "/v1/{siteUrl}/notifications";

    public NotificationsService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public List<NotificationDto> getByActivityId(String activityId) {
        return this.getByActivityId(NotificationGetByActivityIdParams.builder().activityId(activityId).build());
    }

    public List<NotificationDto> getByActivityId(NotificationGetByActivityIdParams params) {
        return this.getByActivityId(params, RequestOptions.create());
    }

    public List<NotificationDto> getByActivityId(NotificationGetByActivityIdParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(NOTIFICATIONS_ACTIVITY_ID_URI).responseClass(NotificationDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public NotificationDto get(String notificationId) {
        return this.get(NotificationGetParams.builder().notificationId(notificationId).build());
    }

    public NotificationDto get(NotificationGetParams params) {
        return this.get(params, RequestOptions.create());
    }

    public NotificationDto get(NotificationGetParams params, RequestOptions requestOptions) {
        return (NotificationDto)this.apiClient().request(ApiRequest.builder().apiPath(NOTIFICATIONS_ID_URI).responseClass(NotificationDto.class).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public Status clear(String notificationId) {
        return this.clear(NotificationClearParams.builder().notificationId(notificationId).build());
    }

    public Status clear(NotificationClearParams params) {
        return this.clear(params, RequestOptions.create());
    }

    public Status clear(NotificationClearParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(CLEAR_NOTIFICATIONS_ID_URI).responseClass(Status.class).method(HttpMethod.POST).options(requestOptions).params(params).build());
    }

    public Status clear(ClearNotificationsRequestData data) {
        return this.clear(data, RequestOptions.create());
    }

    public Status clear(ClearNotificationsRequestData data, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(CLEAR_NOTIFICATIONS_URI).responseClass(Status.class).method(HttpMethod.POST).options(requestOptions).requestData(data).build());
    }

    public List<NotificationDto> getNotifications(String siteUrl) {
        return this.getNotifications(NotificationGetListParams.builder().siteUrl(siteUrl).build());
    }

    public List<NotificationDto> getNotifications(NotificationGetListParams params) {
        return this.getNotifications(params, RequestOptions.create());
    }

    public List<NotificationDto> getNotifications(NotificationGetListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(NOTIFICATIONS_SITE_URI).responseClass(NotificationDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }
}

