/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.leaderboard.model;

import io.mambo.sdk.service.common.model.PointStoreDto;
import io.mambo.sdk.service.common.model.interfaces.HasTranslation;
import io.mambo.sdk.service.leaderboard.model.LeaderboardTranslationDto;
import io.mambo.sdk.service.leaderboard.model.attributes.LeaderboardAttrs;
import io.mambo.sdk.utils.ListUtils;
import io.mambo.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public abstract class AbstractLeaderboard
implements HasTranslation {
    private static final String POINT_IDS = "pointIds";
    protected transient List<String> initializedFields = new ArrayList<String>();
    private String name;
    private String startDate;
    private String endDate;
    private Boolean active;
    private Boolean withRanking;
    private Boolean isReverse;
    private Boolean autoFilterByTag;
    private Boolean includeInactiveUsers;
    private Boolean stopAtZero;
    private List<String> pointIds;
    private List<String> filterableByTagIds;
    private List<String> excludedUsersTagIds;
    private List<String> rankBy;
    private LeaderboardAttrs attrs;
    private List<LeaderboardTranslationDto> translations;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.initializedFields.add("name");
        this.name = name;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.initializedFields.add("active");
        this.active = active;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.initializedFields.add("startDate");
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.initializedFields.add("endDate");
        this.endDate = endDate;
    }

    public List<String> getRankBy() {
        return this.rankBy;
    }

    public void setRankBy(List<String> rankBy) {
        this.initializedFields.add("rankBy");
        this.rankBy = rankBy;
    }

    public Boolean getIsReverse() {
        return this.isReverse;
    }

    public void setIsReverse(Boolean isReverse) {
        this.initializedFields.add("isReverse");
        this.isReverse = isReverse;
    }

    public Boolean getStopAtZero() {
        return this.stopAtZero;
    }

    public void setStopAtZero(Boolean stopAtZero) {
        this.initializedFields.add("stopAtZero");
        this.stopAtZero = stopAtZero;
    }

    public Boolean getAutoFilterByTag() {
        return this.autoFilterByTag;
    }

    public void setAutoFilterByTag(Boolean autoFilterByTag) {
        this.initializedFields.add("autoFilterByTag");
        this.autoFilterByTag = autoFilterByTag;
    }

    public Boolean getIncludeInactiveUsers() {
        return this.includeInactiveUsers;
    }

    public void setIncludeInactiveUsers(Boolean includeInactiveUsers) {
        this.initializedFields.add("includeInactiveUsers");
        this.includeInactiveUsers = includeInactiveUsers;
    }

    public List<String> getFilterableByTagIds() {
        return this.filterableByTagIds;
    }

    public void setFilterableByTagIds(List<String> filterableByTagIds) {
        this.initializedFields.add("filterableByTagIds");
        this.filterableByTagIds = filterableByTagIds;
    }

    public List<String> getExcludedUsersTagIds() {
        return this.excludedUsersTagIds;
    }

    public void setExcludedUsersTagIds(List<String> excludedUsersTagIds) {
        this.initializedFields.add("excludedUsersTagIds");
        this.excludedUsersTagIds = excludedUsersTagIds;
    }

    public LeaderboardAttrs getAttrs() {
        return this.attrs;
    }

    public void setAttrs(LeaderboardAttrs attrs) {
        this.initializedFields.add("attrs");
        this.attrs = attrs;
    }

    public List<String> getPointIds() {
        return this.pointIds;
    }

    public void setPointIds(List<String> pointIds) {
        this.initializedFields.add(POINT_IDS);
        this.pointIds = pointIds;
    }

    public void addPointId(String pointId) {
        if (this.pointIds == null) {
            this.initializedFields.add(POINT_IDS);
            this.pointIds = new ArrayList<String>();
        }
        this.pointIds.add(pointId);
    }

    public void addPoint(PointStoreDto point) {
        this.initializedFields.add(POINT_IDS);
        if (this.pointIds == null) {
            this.pointIds = new ArrayList<String>();
        }
        this.pointIds.add(point.getPointId());
    }

    public List<LeaderboardTranslationDto> getTranslations() {
        return this.translations;
    }

    public void setTranslations(List<LeaderboardTranslationDto> translations) {
        this.initializedFields.add("translations");
        this.translations = translations;
    }

    public void addTranslation(LeaderboardTranslationDto translation) {
        if (this.translations == null) {
            this.initializedFields.add("translations");
            this.translations = new ArrayList<LeaderboardTranslationDto>();
        }
        this.translations.add(translation);
    }

    public LeaderboardTranslationDto getTranslation(String languageCode) {
        if (ListUtils.isEmpty(this.translations)) {
            return null;
        }
        for (LeaderboardTranslationDto translation : this.translations) {
            if (!StringUtils.equals(languageCode, translation.getLanguageCode())) continue;
            return translation;
        }
        return null;
    }

    @Generated
    public String toString() {
        return "AbstractLeaderboard(initializedFields=" + this.initializedFields + ", name=" + this.name + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", active=" + this.active + ", withRanking=" + this.withRanking + ", isReverse=" + this.isReverse + ", autoFilterByTag=" + this.autoFilterByTag + ", includeInactiveUsers=" + this.includeInactiveUsers + ", stopAtZero=" + this.stopAtZero + ", pointIds=" + this.pointIds + ", filterableByTagIds=" + this.filterableByTagIds + ", excludedUsersTagIds=" + this.excludedUsersTagIds + ", rankBy=" + this.rankBy + ", attrs=" + this.attrs + ", translations=" + this.translations + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractLeaderboard)) {
            return false;
        }
        AbstractLeaderboard other = (AbstractLeaderboard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.active;
        Boolean other$active = other.active;
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Boolean this$withRanking = this.withRanking;
        Boolean other$withRanking = other.withRanking;
        if (this$withRanking == null ? other$withRanking != null : !((Object)this$withRanking).equals(other$withRanking)) {
            return false;
        }
        Boolean this$isReverse = this.isReverse;
        Boolean other$isReverse = other.isReverse;
        if (this$isReverse == null ? other$isReverse != null : !((Object)this$isReverse).equals(other$isReverse)) {
            return false;
        }
        Boolean this$autoFilterByTag = this.autoFilterByTag;
        Boolean other$autoFilterByTag = other.autoFilterByTag;
        if (this$autoFilterByTag == null ? other$autoFilterByTag != null : !((Object)this$autoFilterByTag).equals(other$autoFilterByTag)) {
            return false;
        }
        Boolean this$includeInactiveUsers = this.includeInactiveUsers;
        Boolean other$includeInactiveUsers = other.includeInactiveUsers;
        if (this$includeInactiveUsers == null ? other$includeInactiveUsers != null : !((Object)this$includeInactiveUsers).equals(other$includeInactiveUsers)) {
            return false;
        }
        Boolean this$stopAtZero = this.stopAtZero;
        Boolean other$stopAtZero = other.stopAtZero;
        if (this$stopAtZero == null ? other$stopAtZero != null : !((Object)this$stopAtZero).equals(other$stopAtZero)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$startDate = this.startDate;
        String other$startDate = other.startDate;
        if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) {
            return false;
        }
        String this$endDate = this.endDate;
        String other$endDate = other.endDate;
        if (this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate)) {
            return false;
        }
        List<String> this$pointIds = this.pointIds;
        List<String> other$pointIds = other.pointIds;
        if (this$pointIds == null ? other$pointIds != null : !((Object)this$pointIds).equals(other$pointIds)) {
            return false;
        }
        List<String> this$filterableByTagIds = this.filterableByTagIds;
        List<String> other$filterableByTagIds = other.filterableByTagIds;
        if (this$filterableByTagIds == null ? other$filterableByTagIds != null : !((Object)this$filterableByTagIds).equals(other$filterableByTagIds)) {
            return false;
        }
        List<String> this$excludedUsersTagIds = this.excludedUsersTagIds;
        List<String> other$excludedUsersTagIds = other.excludedUsersTagIds;
        if (this$excludedUsersTagIds == null ? other$excludedUsersTagIds != null : !((Object)this$excludedUsersTagIds).equals(other$excludedUsersTagIds)) {
            return false;
        }
        List<String> this$rankBy = this.rankBy;
        List<String> other$rankBy = other.rankBy;
        if (this$rankBy == null ? other$rankBy != null : !((Object)this$rankBy).equals(other$rankBy)) {
            return false;
        }
        LeaderboardAttrs this$attrs = this.attrs;
        LeaderboardAttrs other$attrs = other.attrs;
        if (this$attrs == null ? other$attrs != null : !this$attrs.equals(other$attrs)) {
            return false;
        }
        List<LeaderboardTranslationDto> this$translations = this.translations;
        List<LeaderboardTranslationDto> other$translations = other.translations;
        return !(this$translations == null ? other$translations != null : !((Object)this$translations).equals(other$translations));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractLeaderboard;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.active;
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Boolean $withRanking = this.withRanking;
        result = result * 59 + ($withRanking == null ? 43 : ((Object)$withRanking).hashCode());
        Boolean $isReverse = this.isReverse;
        result = result * 59 + ($isReverse == null ? 43 : ((Object)$isReverse).hashCode());
        Boolean $autoFilterByTag = this.autoFilterByTag;
        result = result * 59 + ($autoFilterByTag == null ? 43 : ((Object)$autoFilterByTag).hashCode());
        Boolean $includeInactiveUsers = this.includeInactiveUsers;
        result = result * 59 + ($includeInactiveUsers == null ? 43 : ((Object)$includeInactiveUsers).hashCode());
        Boolean $stopAtZero = this.stopAtZero;
        result = result * 59 + ($stopAtZero == null ? 43 : ((Object)$stopAtZero).hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $startDate = this.startDate;
        result = result * 59 + ($startDate == null ? 43 : $startDate.hashCode());
        String $endDate = this.endDate;
        result = result * 59 + ($endDate == null ? 43 : $endDate.hashCode());
        List<String> $pointIds = this.pointIds;
        result = result * 59 + ($pointIds == null ? 43 : ((Object)$pointIds).hashCode());
        List<String> $filterableByTagIds = this.filterableByTagIds;
        result = result * 59 + ($filterableByTagIds == null ? 43 : ((Object)$filterableByTagIds).hashCode());
        List<String> $excludedUsersTagIds = this.excludedUsersTagIds;
        result = result * 59 + ($excludedUsersTagIds == null ? 43 : ((Object)$excludedUsersTagIds).hashCode());
        List<String> $rankBy = this.rankBy;
        result = result * 59 + ($rankBy == null ? 43 : ((Object)$rankBy).hashCode());
        LeaderboardAttrs $attrs = this.attrs;
        result = result * 59 + ($attrs == null ? 43 : $attrs.hashCode());
        List<LeaderboardTranslationDto> $translations = this.translations;
        result = result * 59 + ($translations == null ? 43 : ((Object)$translations).hashCode());
        return result;
    }
}

