/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.leaderboard;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.data.DeleteRequestData;
import io.mambo.sdk.service.common.model.response.Status;
import io.mambo.sdk.service.leaderboard.data.LeaderboardRequestData;
import io.mambo.sdk.service.leaderboard.model.LeaderboardDto;
import io.mambo.sdk.service.leaderboard.param.LeaderboardCloneParams;
import io.mambo.sdk.service.leaderboard.param.LeaderboardCreateParams;
import io.mambo.sdk.service.leaderboard.param.LeaderboardDeleteParams;
import io.mambo.sdk.service.leaderboard.param.LeaderboardGetListParams;
import io.mambo.sdk.service.leaderboard.param.LeaderboardGetParams;
import io.mambo.sdk.service.leaderboard.param.LeaderboardRankParams;
import io.mambo.sdk.service.leaderboard.param.LeaderboardRegenerateParams;
import io.mambo.sdk.service.leaderboard.param.LeaderboardUpdateParams;
import java.util.List;

public class LeaderboardsService
extends AbstractService {
    private static final String LEADERBOARDS_URI = "/v1/leaderboards";
    private static final String LEADERBOARDS_ID_URI = "/v1/leaderboards/{leaderboardId}";
    private static final String LEADERBOARDS_CLONE_URI = "/v1/leaderboards/{leaderboardId}/clone";
    private static final String LEADERBOARDS_REGENERATE_URI = "/v1/leaderboards/{leaderboardId}/regenerate";
    private static final String LEADERBOARDS_RANK_URI = "/v1/leaderboards/{leaderboardId}/rank";
    private static final String LEADERBOARDS_SITE_URI = "/v1/{siteUrl}/leaderboards";

    public LeaderboardsService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public LeaderboardDto create(String siteUrl, LeaderboardRequestData data) {
        return this.create(LeaderboardCreateParams.builder().siteUrl(siteUrl).build(), data);
    }

    public LeaderboardDto create(String siteUrl, LeaderboardRequestData data, RequestOptions requestOptions) {
        return this.create(LeaderboardCreateParams.builder().siteUrl(siteUrl).build(), data, requestOptions);
    }

    public LeaderboardDto create(LeaderboardCreateParams params, LeaderboardRequestData data) {
        return this.create(params, data, RequestOptions.create());
    }

    public LeaderboardDto create(LeaderboardCreateParams params, LeaderboardRequestData data, RequestOptions requestOptions) {
        return (LeaderboardDto)this.apiClient().request(ApiRequest.builder().apiPath(LEADERBOARDS_SITE_URI).responseClass(LeaderboardDto.class).method(HttpMethod.POST).requestData(data).options(requestOptions).params(params).build());
    }

    public LeaderboardDto update(String leaderboardId, LeaderboardRequestData data) {
        return this.update(LeaderboardUpdateParams.builder().leaderboardId(leaderboardId).build(), data);
    }

    public LeaderboardDto update(LeaderboardUpdateParams params, LeaderboardRequestData data) {
        return this.update(params, data, RequestOptions.create());
    }

    public LeaderboardDto update(LeaderboardUpdateParams params, LeaderboardRequestData data, RequestOptions requestOptions) {
        return (LeaderboardDto)this.apiClient().request(ApiRequest.builder().apiPath(LEADERBOARDS_ID_URI).responseClass(LeaderboardDto.class).method(HttpMethod.PUT).requestData(data).options(requestOptions).params(params).build());
    }

    public LeaderboardDto clone(String leaderboardId) {
        return this.clone(LeaderboardCloneParams.builder().leaderboardId(leaderboardId).build());
    }

    public LeaderboardDto clone(LeaderboardCloneParams params) {
        return this.clone(params, RequestOptions.create());
    }

    public LeaderboardDto clone(LeaderboardCloneParams params, RequestOptions requestOptions) {
        return (LeaderboardDto)this.apiClient().request(ApiRequest.builder().apiPath(LEADERBOARDS_CLONE_URI).responseClass(LeaderboardDto.class).method(HttpMethod.POST).options(requestOptions).params(params).build());
    }

    public LeaderboardDto regenerate(String leaderboardId) {
        return this.regenerate(LeaderboardRegenerateParams.builder().leaderboardId(leaderboardId).build());
    }

    public LeaderboardDto regenerate(LeaderboardRegenerateParams params) {
        return this.regenerate(params, RequestOptions.create());
    }

    public LeaderboardDto regenerate(LeaderboardRegenerateParams params, RequestOptions requestOptions) {
        return (LeaderboardDto)this.apiClient().request(ApiRequest.builder().apiPath(LEADERBOARDS_REGENERATE_URI).responseClass(LeaderboardDto.class).method(HttpMethod.POST).options(requestOptions).params(params).build());
    }

    public LeaderboardDto rank(String leaderboardId) {
        return this.rank(LeaderboardRankParams.builder().leaderboardId(leaderboardId).build());
    }

    public LeaderboardDto rank(LeaderboardRankParams params) {
        return this.rank(params, RequestOptions.create());
    }

    public LeaderboardDto rank(LeaderboardRankParams params, RequestOptions requestOptions) {
        return (LeaderboardDto)this.apiClient().request(ApiRequest.builder().apiPath(LEADERBOARDS_RANK_URI).responseClass(LeaderboardDto.class).method(HttpMethod.POST).options(requestOptions).params(params).build());
    }

    public Status delete(String leaderboardId) {
        return this.delete(LeaderboardDeleteParams.builder().leaderboardId(leaderboardId).build());
    }

    public Status delete(LeaderboardDeleteParams params) {
        return this.delete(params, RequestOptions.create());
    }

    public Status delete(LeaderboardDeleteParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(LEADERBOARDS_ID_URI).responseClass(Status.class).method(HttpMethod.DELETE).options(requestOptions).params(params).build());
    }

    public Status deleteLeaderboards(DeleteRequestData data) {
        return this.deleteLeaderboards(data, RequestOptions.create());
    }

    public Status deleteLeaderboards(DeleteRequestData data, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(LEADERBOARDS_URI).responseClass(Status.class).method(HttpMethod.DELETE).requestData(data).options(requestOptions).build());
    }

    public LeaderboardDto get(String leaderboardId) {
        return this.get(LeaderboardGetParams.builder().leaderboardId(leaderboardId).build());
    }

    public LeaderboardDto get(LeaderboardGetParams params) {
        return this.get(params, RequestOptions.create());
    }

    public LeaderboardDto get(LeaderboardGetParams params, RequestOptions requestOptions) {
        return (LeaderboardDto)this.apiClient().request(ApiRequest.builder().apiPath(LEADERBOARDS_ID_URI).responseClass(LeaderboardDto.class).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public List<LeaderboardDto> getLeaderboards(String siteUrl) {
        return this.getLeaderboards(LeaderboardGetListParams.builder().siteUrl(siteUrl).build());
    }

    public List<LeaderboardDto> getLeaderboards(LeaderboardGetListParams params) {
        return this.getLeaderboards(params, RequestOptions.create());
    }

    public List<LeaderboardDto> getLeaderboards(LeaderboardGetListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(LEADERBOARDS_SITE_URI).responseClass(LeaderboardDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public LeaderboardRequestData newLeaderboardRequestData() {
        return new LeaderboardRequestData();
    }
}

