/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.language;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.data.DeleteRequestData;
import io.mambo.sdk.service.common.model.response.Status;
import io.mambo.sdk.service.language.data.LanguageRequestData;
import io.mambo.sdk.service.language.model.LanguageDto;
import io.mambo.sdk.service.language.param.LanguageCloneParams;
import io.mambo.sdk.service.language.param.LanguageCreateParams;
import io.mambo.sdk.service.language.param.LanguageDeleteParams;
import io.mambo.sdk.service.language.param.LanguageGetListParams;
import io.mambo.sdk.service.language.param.LanguageGetParams;
import io.mambo.sdk.service.language.param.LanguageUpdateParams;
import java.util.List;

public class LanguagesService
extends AbstractService {
    private static final String LANGUAGES_URI = "/v1/languages";
    private static final String LANGUAGES_ID_URI = "/v1/languages/{languageId}";
    private static final String LANGUAGES_SITE_URI = "/v1/{siteUrl}/languages";
    private static final String LANGUAGES_CLONE_URI = "/v1/languages/{languageId}/clone";

    public LanguagesService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public LanguageDto create(String siteUrl, LanguageRequestData data) {
        return this.create(LanguageCreateParams.builder().siteUrl(siteUrl).build(), data, RequestOptions.create());
    }

    public LanguageDto create(String siteUrl, LanguageRequestData data, RequestOptions requestOptions) {
        return this.create(LanguageCreateParams.builder().siteUrl(siteUrl).build(), data, requestOptions);
    }

    public LanguageDto create(LanguageCreateParams params, LanguageRequestData data) {
        return this.create(params, data, RequestOptions.create());
    }

    public LanguageDto create(LanguageCreateParams params, LanguageRequestData data, RequestOptions requestOptions) {
        return (LanguageDto)this.apiClient().request(ApiRequest.builder().apiPath(LANGUAGES_SITE_URI).responseClass(LanguageDto.class).method(HttpMethod.POST).requestData(data).options(requestOptions).params(params).build());
    }

    public LanguageDto update(String languageId, LanguageRequestData data) {
        return this.update(LanguageUpdateParams.builder().languageId(languageId).build(), data);
    }

    public LanguageDto update(LanguageUpdateParams params, LanguageRequestData data) {
        return this.update(params, data, RequestOptions.create());
    }

    public LanguageDto update(LanguageUpdateParams params, LanguageRequestData data, RequestOptions requestOptions) {
        return (LanguageDto)this.apiClient().request(ApiRequest.builder().apiPath(LANGUAGES_ID_URI).responseClass(LanguageDto.class).method(HttpMethod.PUT).requestData(data).options(requestOptions).params(params).build());
    }

    public LanguageDto clone(String languageId) {
        return this.clone(LanguageCloneParams.builder().languageId(languageId).build());
    }

    public LanguageDto clone(LanguageCloneParams params) {
        return this.clone(params, RequestOptions.create());
    }

    public LanguageDto clone(LanguageCloneParams params, RequestOptions requestOptions) {
        return (LanguageDto)this.apiClient().request(ApiRequest.builder().apiPath(LANGUAGES_CLONE_URI).responseClass(LanguageDto.class).method(HttpMethod.POST).options(requestOptions).params(params).build());
    }

    public Status delete(String languageId) {
        return this.delete(LanguageDeleteParams.builder().languageId(languageId).build());
    }

    public Status delete(LanguageDeleteParams params) {
        return this.delete(params, RequestOptions.create());
    }

    public Status delete(LanguageDeleteParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(LANGUAGES_ID_URI).responseClass(Status.class).method(HttpMethod.DELETE).options(requestOptions).params(params).build());
    }

    public LanguageDto get(String languageId) {
        return this.get(LanguageGetParams.builder().languageId(languageId).build());
    }

    public LanguageDto get(LanguageGetParams params) {
        return this.get(params, RequestOptions.create());
    }

    public LanguageDto get(LanguageGetParams params, RequestOptions requestOptions) {
        return (LanguageDto)this.apiClient().request(ApiRequest.builder().apiPath(LANGUAGES_ID_URI).responseClass(LanguageDto.class).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public Status deleteLanguages(DeleteRequestData data) {
        return this.deleteLanguages(data, RequestOptions.create());
    }

    public Status deleteLanguages(DeleteRequestData data, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(LANGUAGES_URI).responseClass(Status.class).method(HttpMethod.DELETE).requestData(data).options(requestOptions).build());
    }

    public List<LanguageDto> getLanguages(String siteUrl) {
        return this.getLanguages(LanguageGetListParams.builder().siteUrl(siteUrl).build());
    }

    public List<LanguageDto> getLanguages(LanguageGetListParams params) {
        return this.getLanguages(params, RequestOptions.create());
    }

    public List<LanguageDto> getLanguages(LanguageGetListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(LANGUAGES_SITE_URI).responseClass(LanguageDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public LanguageRequestData newLanguageRequestData() {
        return new LanguageRequestData();
    }
}

