/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.kpi.param;

import io.mambo.sdk.service.common.param.AbstractServiceParamsBuilder;
import io.mambo.sdk.service.common.param.ServiceParams;
import io.mambo.sdk.utils.Multimap;
import io.mambo.sdk.utils.Preconditions;
import java.util.List;

public class KpiGetStatesParams
implements ServiceParams {
    private Multimap<String, String> params = new Multimap();

    private KpiGetStatesParams(Builder builder) {
        this.params = builder.params();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Multimap<String, String> asMap() {
        return this.params;
    }

    public static class Builder
    extends AbstractServiceParamsBuilder<Builder> {
        private static final String KPI_ID_MUST_NOT_BE_NULL = "kpiId must not be null";

        public Builder kpiId(String kpiId) {
            Preconditions.checkNotNull(kpiId, KPI_ID_MUST_NOT_BE_NULL);
            this.params.put("kpiId", kpiId);
            return this;
        }

        public Builder page(int page) {
            this.params.put("page", String.valueOf(page));
            return this;
        }

        public Builder count(int count) {
            this.params.put("count", String.valueOf(count));
            return this;
        }

        public Builder tags(List<String> tags) {
            this.params.putAll("tags", tags);
            return this;
        }

        public Builder tagsJoin(String tagsJoin) {
            this.params.put("tagsJoin", tagsJoin);
            return this;
        }

        public Builder tagUuid(String tagUuid) {
            this.params.put("tagUuid", tagUuid);
            return this;
        }

        public Builder period(String period) {
            this.params.put("period", period);
            return this;
        }

        public Builder year(String year) {
            this.params.put("year", year);
            return this;
        }

        public KpiGetStatesParams build() {
            Preconditions.checkContainsKey(this.params, "kpiId", KPI_ID_MUST_NOT_BE_NULL);
            return new KpiGetStatesParams(this);
        }

        private Multimap<String, String> params() {
            return this.params;
        }
    }
}

