/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.kpi;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.data.CustomFieldValueRequestData;
import io.mambo.sdk.service.common.data.DeleteRequestData;
import io.mambo.sdk.service.common.data.FileRequestData;
import io.mambo.sdk.service.common.model.CustomFieldValueDto;
import io.mambo.sdk.service.common.model.response.Status;
import io.mambo.sdk.service.kpi.data.KpiRequestData;
import io.mambo.sdk.service.kpi.data.KpiTargetRequestData;
import io.mambo.sdk.service.kpi.model.KpiDto;
import io.mambo.sdk.service.kpi.model.KpiStateDto;
import io.mambo.sdk.service.kpi.model.KpiTargetDto;
import io.mambo.sdk.service.kpi.param.KpiCloneParams;
import io.mambo.sdk.service.kpi.param.KpiCreateParams;
import io.mambo.sdk.service.kpi.param.KpiCustomFieldParams;
import io.mambo.sdk.service.kpi.param.KpiDeleteParams;
import io.mambo.sdk.service.kpi.param.KpiGetListParams;
import io.mambo.sdk.service.kpi.param.KpiGetParams;
import io.mambo.sdk.service.kpi.param.KpiGetStatesByUserParams;
import io.mambo.sdk.service.kpi.param.KpiGetStatesParams;
import io.mambo.sdk.service.kpi.param.KpiTargetCreateParams;
import io.mambo.sdk.service.kpi.param.KpiTargetGetListParams;
import io.mambo.sdk.service.kpi.param.KpiTargetUpdateParams;
import io.mambo.sdk.service.kpi.param.KpiUpdateParams;
import java.io.File;
import java.util.List;

public class KpisService
extends AbstractService {
    private static final String KPIS_URI = "/v1/kpis";
    private static final String KPIS_ID_URI = "/v1/kpis/{kpiId}";
    private static final String KPIS_IMAGE_URI = "/v1/kpis/{kpiId}/image";
    private static final String KPIS_CLONE_URI = "/v1/kpis/{kpiId}/clone";
    private static final String KPIS_CUSTOM_URI = "/v1/kpis/{kpiId}/custom_fields";
    private static final String KPIS_CUSTOM_IMAGE_URI = "/v1/kpis/{kpiId}/custom_fields/image";
    private static final String KPIS_STATES_URI = "/v1/kpis/{kpiId}/states";
    private static final String KPIS_TARGETS_URI = "/v1/kpis/{kpiId}/targets";
    private static final String KPIS_TARGETS_ID_URI = "/v1/kpis/targets/{targetId}";
    private static final String KPIS_TARGETS_NO_ID_URI = "/v1/kpis/targets";
    private static final String KPIS_SITE_URI = "/v1/{siteUrl}/kpis";
    private static final String KPIS_UUID_URI = "/v1/{siteUrl}/kpis/{uuid}";

    public KpisService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public KpiDto create(String siteUrl, KpiRequestData data) {
        return this.create(KpiCreateParams.builder().siteUrl(siteUrl).build(), data, RequestOptions.create());
    }

    public KpiDto create(String siteUrl, KpiRequestData data, RequestOptions requestOptions) {
        return this.create(KpiCreateParams.builder().siteUrl(siteUrl).build(), data, requestOptions);
    }

    public KpiDto create(KpiCreateParams params, KpiRequestData data) {
        return this.create(params, data, RequestOptions.create());
    }

    public KpiDto create(KpiCreateParams params, KpiRequestData data, RequestOptions requestOptions) {
        return (KpiDto)this.apiClient().request(ApiRequest.builder().apiPath(KPIS_SITE_URI).responseClass(KpiDto.class).method(HttpMethod.POST).requestData(data).params(params).options(requestOptions).build());
    }

    public KpiDto update(String kpiId, KpiRequestData data) {
        return this.update(KpiUpdateParams.builder().kpiId(kpiId).build(), data);
    }

    public KpiDto update(KpiUpdateParams params, KpiRequestData data) {
        return this.update(params, data, RequestOptions.create());
    }

    public KpiDto update(KpiUpdateParams params, KpiRequestData data, RequestOptions requestOptions) {
        return (KpiDto)this.apiClient().request(ApiRequest.builder().apiPath(KPIS_ID_URI).responseClass(KpiDto.class).method(HttpMethod.PUT).requestData(data).params(params).options(requestOptions).build());
    }

    public KpiDto uploadImage(String kpiId, File image) {
        return this.uploadImage(KpiUpdateParams.builder().kpiId(kpiId).build(), image);
    }

    public KpiDto uploadImage(KpiUpdateParams params, File image) {
        return this.uploadImage(params, image, RequestOptions.create());
    }

    public KpiDto uploadImage(KpiUpdateParams params, File image, RequestOptions requestOptions) {
        return (KpiDto)this.apiClient().request(ApiRequest.builder().apiPath(KPIS_IMAGE_URI).responseClass(KpiDto.class).method(HttpMethod.POST).requestData(new FileRequestData(image)).params(params).options(requestOptions).build());
    }

    public KpiDto clone(String kpiId) {
        return this.clone(KpiCloneParams.builder().kpiId(kpiId).build());
    }

    public KpiDto clone(KpiCloneParams params) {
        return this.clone(params, RequestOptions.create());
    }

    public KpiDto clone(KpiCloneParams params, RequestOptions requestOptions) {
        return (KpiDto)this.apiClient().request(ApiRequest.builder().apiPath(KPIS_CLONE_URI).responseClass(KpiDto.class).method(HttpMethod.POST).params(params).options(requestOptions).build());
    }

    public Status delete(String kpiId) {
        return this.delete(KpiDeleteParams.builder().kpiId(kpiId).build());
    }

    public Status delete(KpiDeleteParams params) {
        return this.delete(params, RequestOptions.create());
    }

    public Status delete(KpiDeleteParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(KPIS_ID_URI).responseClass(Status.class).method(HttpMethod.DELETE).params(params).options(requestOptions).build());
    }

    public KpiDto get(String kpiId) {
        return this.get(KpiGetParams.builder().kpiId(kpiId).build());
    }

    public KpiDto get(KpiGetParams params) {
        return this.get(params, RequestOptions.create());
    }

    public KpiDto get(KpiGetParams params, RequestOptions requestOptions) {
        return (KpiDto)this.apiClient().request(ApiRequest.builder().apiPath(KPIS_ID_URI).responseClass(KpiDto.class).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public Status deleteKpis(DeleteRequestData data) {
        return this.deleteKpis(data, RequestOptions.create());
    }

    public Status deleteKpis(DeleteRequestData data, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(KPIS_URI).responseClass(Status.class).method(HttpMethod.DELETE).requestData(data).options(requestOptions).build());
    }

    public List<KpiDto> getKpis(String siteUrl) {
        return this.getKpis(KpiGetListParams.builder().siteUrl(siteUrl).build(), RequestOptions.create());
    }

    public List<KpiDto> getKpis(KpiGetListParams params) {
        return this.getKpis(params, RequestOptions.create());
    }

    public List<KpiDto> getKpis(KpiGetListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(KPIS_SITE_URI).responseClass(KpiDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public List<KpiStateDto> getKpiStates(String kpiId) {
        return this.getKpiStates(KpiGetStatesParams.builder().kpiId(kpiId).build(), RequestOptions.create());
    }

    public List<KpiStateDto> getKpiStates(KpiGetStatesParams params) {
        return this.getKpiStates(params, RequestOptions.create());
    }

    public List<KpiStateDto> getKpiStates(KpiGetStatesParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(KPIS_STATES_URI).responseClass(KpiStateDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public List<KpiStateDto> getKpiStatesByUser(String siteUrl, String uuid) {
        return this.getKpiStatesByUser(KpiGetStatesByUserParams.builder().siteUrl(siteUrl).uuid(uuid).build(), RequestOptions.create());
    }

    public List<KpiStateDto> getKpiStatesByUser(KpiGetStatesByUserParams params) {
        return this.getKpiStatesByUser(params, RequestOptions.create());
    }

    public List<KpiStateDto> getKpiStatesByUser(KpiGetStatesByUserParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(KPIS_UUID_URI).responseClass(KpiStateDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public KpiTargetDto createKpiTarget(String kpiId, KpiTargetRequestData data) {
        return this.createKpiTarget(KpiTargetCreateParams.builder().kpiId(kpiId).build(), data, RequestOptions.create());
    }

    public KpiTargetDto createKpiTarget(String kpiId, KpiTargetRequestData data, RequestOptions requestOptions) {
        return this.createKpiTarget(KpiTargetCreateParams.builder().kpiId(kpiId).build(), data, requestOptions);
    }

    public KpiTargetDto createKpiTarget(KpiTargetCreateParams params, KpiTargetRequestData data) {
        return this.createKpiTarget(params, data, RequestOptions.create());
    }

    public KpiTargetDto createKpiTarget(KpiTargetCreateParams params, KpiTargetRequestData data, RequestOptions requestOptions) {
        return (KpiTargetDto)this.apiClient().request(ApiRequest.builder().apiPath(KPIS_TARGETS_URI).responseClass(KpiTargetDto.class).method(HttpMethod.POST).requestData(data).params(params).options(requestOptions).build());
    }

    public KpiTargetDto updateKpiTarget(String targetId, KpiTargetRequestData data) {
        return this.updateKpiTarget(KpiTargetUpdateParams.builder().targetId(targetId).build(), data);
    }

    public KpiTargetDto updateKpiTarget(KpiTargetUpdateParams params, KpiTargetRequestData data) {
        return this.updateKpiTarget(params, data, RequestOptions.create());
    }

    public KpiTargetDto updateKpiTarget(KpiTargetUpdateParams params, KpiTargetRequestData data, RequestOptions requestOptions) {
        return (KpiTargetDto)this.apiClient().request(ApiRequest.builder().apiPath(KPIS_TARGETS_ID_URI).responseClass(KpiTargetDto.class).method(HttpMethod.PUT).requestData(data).params(params).options(requestOptions).build());
    }

    public Status deleteKpiTargets(DeleteRequestData data) {
        return this.deleteKpiTargets(data, RequestOptions.create());
    }

    public Status deleteKpiTargets(DeleteRequestData data, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(KPIS_TARGETS_NO_ID_URI).responseClass(Status.class).method(HttpMethod.DELETE).requestData(data).options(requestOptions).build());
    }

    public List<KpiTargetDto> getKpiTargets(String kpiId) {
        return this.getKpiTargets(KpiTargetGetListParams.builder().kpiId(kpiId).build());
    }

    public List<KpiTargetDto> getKpiTargets(KpiTargetGetListParams params) {
        return this.getKpiTargets(params, RequestOptions.create());
    }

    public List<KpiTargetDto> getKpiTargets(KpiTargetGetListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(KPIS_TARGETS_URI).responseClass(KpiTargetDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).params(params).options(requestOptions).build());
    }

    public KpiDto addCustomFields(String kpiId, CustomFieldValueRequestData data) {
        return this.addCustomFields(KpiCustomFieldParams.builder().kpiId(kpiId).build(), data, RequestOptions.create());
    }

    public KpiDto addCustomFields(KpiCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.addCustomFields(params, data, RequestOptions.create());
    }

    public KpiDto addCustomFields(KpiCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return this.modCustomFields(HttpMethod.POST, params, data, requestOptions);
    }

    public KpiDto updateCustomFields(String kpiId, CustomFieldValueRequestData data) {
        return this.updateCustomFields(KpiCustomFieldParams.builder().kpiId(kpiId).build(), data, RequestOptions.create());
    }

    public KpiDto updateCustomFields(KpiCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.updateCustomFields(params, data, RequestOptions.create());
    }

    public KpiDto updateCustomFields(KpiCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return this.modCustomFields(HttpMethod.PUT, params, data, requestOptions);
    }

    public KpiDto deleteCustomFields(String kpiId, CustomFieldValueRequestData data) {
        return this.deleteCustomFields(KpiCustomFieldParams.builder().kpiId(kpiId).build(), data, RequestOptions.create());
    }

    public KpiDto deleteCustomFields(KpiCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.deleteCustomFields(params, data, RequestOptions.create());
    }

    public KpiDto deleteCustomFields(KpiCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return this.modCustomFields(HttpMethod.DELETE, params, data, requestOptions);
    }

    private KpiDto modCustomFields(HttpMethod method, KpiCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return (KpiDto)this.apiClient().request(ApiRequest.builder().apiPath(KPIS_CUSTOM_URI).responseClass(KpiDto.class).method(method).requestData(data).params(params).options(requestOptions).build());
    }

    public KpiDto addCustomField(KpiCustomFieldParams params, CustomFieldValueDto data, File image) {
        return this.addCustomField(params, data, image, RequestOptions.create());
    }

    public KpiDto addCustomField(KpiCustomFieldParams params, CustomFieldValueDto data, File image, RequestOptions requestOptions) {
        return (KpiDto)this.apiClient().request(ApiRequest.builder().apiPath(KPIS_CUSTOM_IMAGE_URI).responseClass(KpiDto.class).method(HttpMethod.POST).requestData(new FileRequestData(image, data)).params(params).options(requestOptions).build());
    }

    public KpiRequestData newKpiRequestData() {
        return new KpiRequestData();
    }

    public KpiTargetRequestData newKpiTargetRequestData() {
        return new KpiTargetRequestData();
    }
}

