/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.datastore.param;

import io.mambo.sdk.service.common.param.AbstractServiceParamsBuilder;
import io.mambo.sdk.service.common.param.ServiceParams;
import io.mambo.sdk.utils.Multimap;
import io.mambo.sdk.utils.Preconditions;

public class DataStoreUpdateParams
implements ServiceParams {
    private Multimap<String, String> params = new Multimap();
    private static final String DATA_STORE_ID_MUST_NOT_BE_NULL = "dataStoreId must not be null";

    private DataStoreUpdateParams(Builder builder) {
        this.params = builder.params();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Multimap<String, String> asMap() {
        return this.params;
    }

    public static class Builder
    extends AbstractServiceParamsBuilder<Builder> {
        public Builder dataStoreId(String dataStoreId) {
            Preconditions.checkNotNull(dataStoreId, DataStoreUpdateParams.DATA_STORE_ID_MUST_NOT_BE_NULL);
            this.params.put("dataStoreId", dataStoreId);
            return this;
        }

        public DataStoreUpdateParams build() {
            Preconditions.checkContainsKey(this.params, "dataStoreId", DataStoreUpdateParams.DATA_STORE_ID_MUST_NOT_BE_NULL);
            return new DataStoreUpdateParams(this);
        }

        private Multimap<String, String> params() {
            return this.params;
        }
    }
}

