/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.datastore.param;

import io.mambo.sdk.service.common.param.AbstractServiceParamsBuilder;
import io.mambo.sdk.service.common.param.Order;
import io.mambo.sdk.service.common.param.ServiceParams;
import io.mambo.sdk.utils.Multimap;
import io.mambo.sdk.utils.Preconditions;
import java.util.List;

public class DataStoreGetListParams
implements ServiceParams {
    private Multimap<String, String> params = new Multimap();

    private DataStoreGetListParams(Builder builder) {
        this.params = builder.params();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Multimap<String, String> asMap() {
        return this.params;
    }

    public static class Builder
    extends AbstractServiceParamsBuilder<Builder> {
        public Builder siteUrl(String siteUrl) {
            Preconditions.checkNotNull(siteUrl, "siteUrl must not be null");
            this.params.put("siteUrl", siteUrl);
            return this;
        }

        public Builder page(int page) {
            this.params.put("page", String.valueOf(page));
            return this;
        }

        public Builder count(int count) {
            this.params.put("count", String.valueOf(count));
            return this;
        }

        public Builder type(String type) {
            this.params.put("type", type);
            return this;
        }

        public Builder ownedByIds(List<String> ownedByIds) {
            this.params.putAll("ownedByIds", ownedByIds);
            return this;
        }

        public Builder ownedByUuids(List<String> ownedByUuids) {
            this.params.putAll("ownedByUuids", ownedByUuids);
            return this;
        }

        public Builder userIds(List<String> userIds) {
            this.params.putAll("userIds", userIds);
            return this;
        }

        public Builder userUuids(List<String> userUuids) {
            this.params.putAll("userUuids", userUuids);
            return this;
        }

        public Builder startDate(String startDate) {
            this.params.put("startDate", startDate);
            return this;
        }

        public Builder endDate(String endDate) {
            this.params.put("endDate", endDate);
            return this;
        }

        public Builder order(Order order) {
            this.params.put("order", order.value());
            return this;
        }

        public Builder includeSystemDataStores(boolean includeSystemDataStores) {
            this.params.put("includeSystemDataStores", String.valueOf(includeSystemDataStores));
            return this;
        }

        public Builder withUsers(boolean withUsers) {
            this.params.put("withUsers", String.valueOf(withUsers));
            return this;
        }

        public Builder userProperties(List<String> userProperties) {
            this.params.putAll("userProperties", userProperties);
            return this;
        }

        public DataStoreGetListParams build() {
            Preconditions.checkContainsKey(this.params, "siteUrl", "siteUrl must not be null");
            return new DataStoreGetListParams(this);
        }

        private Multimap<String, String> params() {
            return this.params;
        }
    }
}

