/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.datastore;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.data.DeleteRequestData;
import io.mambo.sdk.service.common.model.response.Status;
import io.mambo.sdk.service.datastore.data.DataStoreRequestData;
import io.mambo.sdk.service.datastore.model.DataStoreDto;
import io.mambo.sdk.service.datastore.param.DataStoreCloneParams;
import io.mambo.sdk.service.datastore.param.DataStoreCreateParams;
import io.mambo.sdk.service.datastore.param.DataStoreDeleteByCriteriaParams;
import io.mambo.sdk.service.datastore.param.DataStoreDeleteParams;
import io.mambo.sdk.service.datastore.param.DataStoreGetListParams;
import io.mambo.sdk.service.datastore.param.DataStoreGetParams;
import io.mambo.sdk.service.datastore.param.DataStoreUpdateParams;
import java.util.List;

public class DataStoresService
extends AbstractService {
    private static final String DATA_STORES_URI = "/v1/data_stores";
    private static final String DATA_STORES_ID_URI = "/v1/data_stores/{dataStoreId}";
    private static final String DATA_STORES_CLONE_URI = "/v1/data_stores/{dataStoreId}/clone";
    private static final String DATA_STORES_SITE_URI = "/v1/{siteUrl}/data_stores";

    public DataStoresService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public DataStoreDto create(String siteUrl, DataStoreRequestData data) {
        return this.create(DataStoreCreateParams.builder().siteUrl(siteUrl).build(), data);
    }

    public DataStoreDto create(String siteUrl, DataStoreRequestData data, RequestOptions requestOptions) {
        return this.create(DataStoreCreateParams.builder().siteUrl(siteUrl).build(), data, requestOptions);
    }

    public DataStoreDto create(DataStoreCreateParams params, DataStoreRequestData data) {
        return this.create(params, data, RequestOptions.create());
    }

    public DataStoreDto create(DataStoreCreateParams params, DataStoreRequestData data, RequestOptions requestOptions) {
        return (DataStoreDto)this.apiClient().request(ApiRequest.builder().apiPath(DATA_STORES_SITE_URI).responseClass(DataStoreDto.class).method(HttpMethod.POST).requestData(data).options(requestOptions).params(params).build());
    }

    public DataStoreDto update(String dataStoreId, DataStoreRequestData data) {
        return this.update(DataStoreUpdateParams.builder().dataStoreId(dataStoreId).build(), data);
    }

    public DataStoreDto update(DataStoreUpdateParams params, DataStoreRequestData data) {
        return this.update(params, data, RequestOptions.create());
    }

    public DataStoreDto update(DataStoreUpdateParams params, DataStoreRequestData data, RequestOptions requestOptions) {
        return (DataStoreDto)this.apiClient().request(ApiRequest.builder().apiPath(DATA_STORES_ID_URI).responseClass(DataStoreDto.class).method(HttpMethod.PUT).requestData(data).options(requestOptions).params(params).build());
    }

    public DataStoreDto clone(String dataStoreId) {
        return this.clone(DataStoreCloneParams.builder().dataStoreId(dataStoreId).build());
    }

    public DataStoreDto clone(DataStoreCloneParams params) {
        return this.clone(params, RequestOptions.create());
    }

    public DataStoreDto clone(DataStoreCloneParams params, RequestOptions requestOptions) {
        return (DataStoreDto)this.apiClient().request(ApiRequest.builder().apiPath(DATA_STORES_CLONE_URI).responseClass(DataStoreDto.class).method(HttpMethod.POST).options(requestOptions).params(params).build());
    }

    public Status delete(String dataStoreId) {
        return this.delete(dataStoreId, false);
    }

    public Status delete(String dataStoreId, boolean includeSystemDataStores) {
        return this.delete(DataStoreDeleteParams.builder().dataStoreId(dataStoreId).includeSystemDataStores(includeSystemDataStores).build());
    }

    public Status delete(DataStoreDeleteParams params) {
        return this.delete(params, RequestOptions.create());
    }

    public Status delete(DataStoreDeleteParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(DATA_STORES_ID_URI).responseClass(Status.class).method(HttpMethod.DELETE).options(requestOptions).params(params).build());
    }

    public DataStoreDto get(String dataStoreId) {
        return this.get(DataStoreGetParams.builder().dataStoreId(dataStoreId).build());
    }

    public DataStoreDto get(DataStoreGetParams params) {
        return this.get(params, RequestOptions.create());
    }

    public DataStoreDto get(DataStoreGetParams params, RequestOptions requestOptions) {
        return (DataStoreDto)this.apiClient().request(ApiRequest.builder().apiPath(DATA_STORES_ID_URI).responseClass(DataStoreDto.class).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public Status deleteDataStores(DeleteRequestData data) {
        return this.deleteDataStores(data, false);
    }

    public Status deleteDataStores(DeleteRequestData data, RequestOptions requestOptions) {
        return this.deleteDataStores(data, false, requestOptions);
    }

    public Status deleteDataStores(DeleteRequestData data, boolean includeSystemDataStores) {
        return this.deleteDataStores(data, includeSystemDataStores, RequestOptions.create());
    }

    public Status deleteDataStores(DeleteRequestData data, boolean includeSystemDataStores, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(DATA_STORES_URI).responseClass(Status.class).method(HttpMethod.DELETE).requestData(data).options(requestOptions).params(DataStoreDeleteParams.builder().includeSystemDataStores(includeSystemDataStores).build()).build());
    }

    public Status deleteDataStoresByCriteria(DataStoreDeleteByCriteriaParams params) {
        return this.deleteDataStoresByCriteria(params, RequestOptions.create());
    }

    public Status deleteDataStoresByCriteria(DataStoreDeleteByCriteriaParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(DATA_STORES_SITE_URI).responseClass(Status.class).method(HttpMethod.DELETE).options(requestOptions).params(params).build());
    }

    public List<DataStoreDto> getDataStores(String siteUrl) {
        return this.getDataStores(DataStoreGetListParams.builder().siteUrl(siteUrl).build(), RequestOptions.create());
    }

    public List<DataStoreDto> getDataStores(DataStoreGetListParams params) {
        return this.getDataStores(params, RequestOptions.create());
    }

    public List<DataStoreDto> getDataStores(DataStoreGetListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(DATA_STORES_SITE_URI).responseClass(DataStoreDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public DataStoreRequestData newDataStoreRequestData() {
        return new DataStoreRequestData();
    }
}

