/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.customfield;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.data.DeleteRequestData;
import io.mambo.sdk.service.common.model.response.Status;
import io.mambo.sdk.service.customfield.data.CustomFieldRequestData;
import io.mambo.sdk.service.customfield.model.CustomFieldDto;
import io.mambo.sdk.service.customfield.param.CustomFieldCloneParams;
import io.mambo.sdk.service.customfield.param.CustomFieldCreateParams;
import io.mambo.sdk.service.customfield.param.CustomFieldDeleteParams;
import io.mambo.sdk.service.customfield.param.CustomFieldGetListParams;
import io.mambo.sdk.service.customfield.param.CustomFieldGetParams;
import io.mambo.sdk.service.customfield.param.CustomFieldUpdateParams;
import java.util.List;

public class CustomFieldsService
extends AbstractService {
    private static final String CUSTOM_FIELDS_URI = "/v1/custom_fields";
    private static final String CUSTOM_FIELDS_ID_URI = "/v1/custom_fields/{customFieldId}";
    private static final String CUSTOM_FIELDS_SITE_URI = "/v1/{siteUrl}/custom_fields";
    private static final String CUSTOM_FIELDS_CLONE_URI = "/v1/custom_fields/{customFieldId}/clone";

    public CustomFieldsService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public CustomFieldDto create(String siteUrl, CustomFieldRequestData data) {
        return this.create(CustomFieldCreateParams.builder().siteUrl(siteUrl).build(), data);
    }

    public CustomFieldDto create(String siteUrl, CustomFieldRequestData data, RequestOptions requestOptions) {
        return this.create(CustomFieldCreateParams.builder().siteUrl(siteUrl).build(), data, requestOptions);
    }

    public CustomFieldDto create(CustomFieldCreateParams params, CustomFieldRequestData data) {
        return this.create(params, data, RequestOptions.create());
    }

    public CustomFieldDto create(CustomFieldCreateParams params, CustomFieldRequestData data, RequestOptions requestOptions) {
        return (CustomFieldDto)this.apiClient().request(ApiRequest.builder().apiPath(CUSTOM_FIELDS_SITE_URI).responseClass(CustomFieldDto.class).method(HttpMethod.POST).requestData(data).options(requestOptions).params(params).build());
    }

    public CustomFieldDto update(String customFieldId, CustomFieldRequestData data) {
        return this.update(CustomFieldUpdateParams.builder().customFieldId(customFieldId).build(), data);
    }

    public CustomFieldDto update(CustomFieldUpdateParams params, CustomFieldRequestData data) {
        return this.update(params, data, RequestOptions.create());
    }

    public CustomFieldDto update(CustomFieldUpdateParams params, CustomFieldRequestData data, RequestOptions requestOptions) {
        return (CustomFieldDto)this.apiClient().request(ApiRequest.builder().apiPath(CUSTOM_FIELDS_ID_URI).responseClass(CustomFieldDto.class).method(HttpMethod.PUT).requestData(data).options(requestOptions).params(params).build());
    }

    public CustomFieldDto clone(String customFieldId) {
        return this.clone(CustomFieldCloneParams.builder().customFieldId(customFieldId).build());
    }

    public CustomFieldDto clone(CustomFieldCloneParams params) {
        return this.clone(params, RequestOptions.create());
    }

    public CustomFieldDto clone(CustomFieldCloneParams params, RequestOptions requestOptions) {
        return (CustomFieldDto)this.apiClient().request(ApiRequest.builder().apiPath(CUSTOM_FIELDS_CLONE_URI).responseClass(CustomFieldDto.class).method(HttpMethod.POST).options(requestOptions).params(params).build());
    }

    public Status delete(String customFieldId) {
        return this.delete(CustomFieldDeleteParams.builder().customFieldId(customFieldId).build());
    }

    public Status delete(CustomFieldDeleteParams params) {
        return this.delete(params, RequestOptions.create());
    }

    public Status delete(CustomFieldDeleteParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(CUSTOM_FIELDS_ID_URI).responseClass(Status.class).method(HttpMethod.DELETE).options(requestOptions).params(params).build());
    }

    public CustomFieldDto get(String customFieldId) {
        return this.get(CustomFieldGetParams.builder().customFieldId(customFieldId).build());
    }

    public CustomFieldDto get(CustomFieldGetParams params) {
        return this.get(params, RequestOptions.create());
    }

    public CustomFieldDto get(CustomFieldGetParams params, RequestOptions requestOptions) {
        return (CustomFieldDto)this.apiClient().request(ApiRequest.builder().apiPath(CUSTOM_FIELDS_ID_URI).responseClass(CustomFieldDto.class).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public Status deleteCustomFields(DeleteRequestData data) {
        return this.deleteCustomFields(data, RequestOptions.create());
    }

    public Status deleteCustomFields(DeleteRequestData data, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(CUSTOM_FIELDS_URI).responseClass(Status.class).method(HttpMethod.DELETE).requestData(data).options(requestOptions).build());
    }

    public List<CustomFieldDto> getCustomFields(String siteUrl) {
        return this.getCustomFields(CustomFieldGetListParams.builder().siteUrl(siteUrl).build());
    }

    public List<CustomFieldDto> getCustomFields(CustomFieldGetListParams params) {
        return this.getCustomFields(params, RequestOptions.create());
    }

    public List<CustomFieldDto> getCustomFields(CustomFieldGetListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(CUSTOM_FIELDS_SITE_URI).responseClass(CustomFieldDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public CustomFieldRequestData newCustomFieldRequestData() {
        return new CustomFieldRequestData();
    }
}

