/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.coupon.param;

import io.mambo.sdk.service.common.param.AbstractServiceParamsBuilder;
import io.mambo.sdk.service.common.param.ServiceParams;
import io.mambo.sdk.utils.Multimap;
import io.mambo.sdk.utils.Preconditions;
import java.util.List;

public class CouponGetStateListParams
implements ServiceParams {
    private Multimap<String, String> params = new Multimap();

    private CouponGetStateListParams(Builder builder) {
        this.params = builder.params();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Multimap<String, String> asMap() {
        return this.params;
    }

    public static class Builder
    extends AbstractServiceParamsBuilder<Builder> {
        public Builder siteUrl(String siteUrl) {
            Preconditions.checkNotNull(siteUrl, "siteUrl must not be null");
            this.params.put("siteUrl", siteUrl);
            return this;
        }

        public Builder page(int page) {
            this.params.put("page", String.valueOf(page));
            return this;
        }

        public Builder count(int count) {
            this.params.put("count", String.valueOf(count));
            return this;
        }

        public Builder tags(List<String> tags) {
            this.params.putAll("tags", tags);
            return this;
        }

        public Builder tagsJoin(String tagsJoin) {
            this.params.put("tagsJoin", tagsJoin);
            return this;
        }

        public Builder tagUuid(String tagUuid) {
            this.params.put("tagUuid", tagUuid);
            return this;
        }

        public Builder startDate(String startDate) {
            this.params.put("startDate", startDate);
            return this;
        }

        public Builder endDate(String endDate) {
            this.params.put("endDate", endDate);
            return this;
        }

        public Builder awardedToUserIds(List<String> awardedToUserIds) {
            this.params.putAll("awardedToUserIds", awardedToUserIds);
            return this;
        }

        public Builder awardedToUuids(List<String> awardedToUuids) {
            this.params.putAll("awardedToUuids", awardedToUuids);
            return this;
        }

        public Builder couponIds(List<String> couponIds) {
            this.params.putAll("couponIds", couponIds);
            return this;
        }

        public Builder activityIds(List<String> activityIds) {
            this.params.putAll("activityIds", activityIds);
            return this;
        }

        public Builder withRedeemableOnly(boolean withRedeemableOnly) {
            this.params.put("withRedeemableOnly", String.valueOf(withRedeemableOnly));
            return this;
        }

        public Builder withRedeemedOnly(boolean withRedeemedOnly) {
            this.params.put("withRedeemedOnly", String.valueOf(withRedeemedOnly));
            return this;
        }

        public Builder withExpiredOnly(boolean withExpiredOnly) {
            this.params.put("withExpiredOnly", String.valueOf(withExpiredOnly));
            return this;
        }

        public CouponGetStateListParams build() {
            Preconditions.checkContainsKey(this.params, "siteUrl", "siteUrl must not be null");
            return new CouponGetStateListParams(this);
        }

        private Multimap<String, String> params() {
            return this.params;
        }
    }
}

