/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.coupon.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.mambo.sdk.service.common.model.CustomFieldValueDto;
import io.mambo.sdk.service.common.model.ScarcityDto;
import io.mambo.sdk.service.common.model.interfaces.HasCustomFields;
import io.mambo.sdk.service.common.model.interfaces.HasInitializedData;
import io.mambo.sdk.service.common.model.interfaces.HasRecurrence;
import io.mambo.sdk.service.common.model.interfaces.HasTranslation;
import io.mambo.sdk.service.common.model.recurrence.RecurrenceDto;
import io.mambo.sdk.service.coupon.model.BuyCriteriaDto;
import io.mambo.sdk.service.coupon.model.CouponTranslationDto;
import io.mambo.sdk.service.coupon.model.code.CouponCodeDto;
import io.mambo.sdk.service.coupon.model.code.MultipleCouponCodeDto;
import io.mambo.sdk.service.coupon.model.code.SingleCouponCodeDto;
import io.mambo.sdk.utils.ListUtils;
import io.mambo.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public abstract class AbstractCoupon
implements HasTranslation,
HasCustomFields,
HasRecurrence,
HasInitializedData {
    protected transient List<String> initializedFields = new ArrayList<String>();
    private String name;
    private String type;
    private String helpMessage;
    private String custom;
    private String usage;
    private CouponCodeDto couponCode;
    private Double amount;
    private Boolean active;
    private ScarcityDto scarcity;
    private BuyCriteriaDto buyCriteria;
    private RecurrenceDto expiration;
    private List<CustomFieldValueDto> customFields;
    private List<CouponTranslationDto> translations;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.initializedFields.add("name");
        this.name = name;
    }

    public CouponCodeDto getCouponCode() {
        return this.couponCode;
    }

    public void setCouponCode(CouponCodeDto code) {
        this.initializedFields.add("couponCode");
        this.couponCode = code;
    }

    public boolean isSingleCouponCode() {
        return StringUtils.equals("single", this.getCouponCode().getType());
    }

    public SingleCouponCodeDto getSingleCouponCode() {
        return (SingleCouponCodeDto)this.getCouponCode();
    }

    public boolean isMultipleCouponCode() {
        return StringUtils.equals("multiple", this.getCouponCode().getType());
    }

    public MultipleCouponCodeDto getMultipleCouponCode() {
        return (MultipleCouponCodeDto)this.getCouponCode();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.initializedFields.add("type");
        this.type = type;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.initializedFields.add("active");
        this.active = active;
    }

    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.initializedFields.add("amount");
        this.amount = amount;
    }

    public String getCustomPrize() {
        return this.custom;
    }

    @JsonProperty(value="custom")
    public void setCustomPrize(String custom) {
        this.initializedFields.add("custom");
        this.custom = custom;
    }

    public BuyCriteriaDto getBuyCriteria() {
        return this.buyCriteria;
    }

    public void setBuyCriteria(BuyCriteriaDto buyCriteria) {
        this.initializedFields.add("buyCriteria");
        this.buyCriteria = buyCriteria;
    }

    public ScarcityDto getScarcity() {
        return this.scarcity;
    }

    public void setScarcity(ScarcityDto scarcity) {
        this.initializedFields.add("scarcity");
        this.scarcity = scarcity;
    }

    public String getHelpMessage() {
        return this.helpMessage;
    }

    public void setHelpMessage(String helpMessage) {
        this.initializedFields.add("helpMessage");
        this.helpMessage = helpMessage;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.initializedFields.add("usage");
        this.usage = usage;
    }

    @Override
    public RecurrenceDto getExpiration() {
        return this.expiration;
    }

    @Override
    public void setExpiration(RecurrenceDto expiration) {
        this.initializedFields.add("expiration");
        this.expiration = expiration;
    }

    @Override
    public List<CustomFieldValueDto> getCustomFields() {
        return this.customFields;
    }

    @Override
    public void setCustomFields(List<CustomFieldValueDto> customFields) {
        this.initializedFields.add("customFields");
        this.customFields = customFields;
    }

    public List<CouponTranslationDto> getTranslations() {
        return this.translations;
    }

    public void setTranslations(List<CouponTranslationDto> translations) {
        this.initializedFields.add("translations");
        this.translations = translations;
    }

    public void addTranslation(CouponTranslationDto translation) {
        if (this.translations == null) {
            this.initializedFields.add("translations");
            this.translations = new ArrayList<CouponTranslationDto>();
        }
        this.translations.add(translation);
    }

    public CouponTranslationDto getTranslation(String languageCode) {
        if (ListUtils.isEmpty(this.translations)) {
            return null;
        }
        for (CouponTranslationDto translation : this.translations) {
            if (!StringUtils.equals(languageCode, translation.getLanguageCode())) continue;
            return translation;
        }
        return null;
    }

    @Override
    public List<String> getInitializedFields() {
        return this.initializedFields;
    }

    @Generated
    public String toString() {
        return "AbstractCoupon(initializedFields=" + this.initializedFields + ", name=" + this.name + ", type=" + this.type + ", helpMessage=" + this.helpMessage + ", custom=" + this.custom + ", usage=" + this.usage + ", couponCode=" + this.couponCode + ", amount=" + this.amount + ", active=" + this.active + ", scarcity=" + this.scarcity + ", buyCriteria=" + this.buyCriteria + ", expiration=" + this.expiration + ", customFields=" + this.customFields + ", translations=" + this.translations + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractCoupon)) {
            return false;
        }
        AbstractCoupon other = (AbstractCoupon)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$amount = this.amount;
        Double other$amount = other.amount;
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Boolean this$active = this.active;
        Boolean other$active = other.active;
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.type;
        String other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$helpMessage = this.helpMessage;
        String other$helpMessage = other.helpMessage;
        if (this$helpMessage == null ? other$helpMessage != null : !this$helpMessage.equals(other$helpMessage)) {
            return false;
        }
        String this$custom = this.custom;
        String other$custom = other.custom;
        if (this$custom == null ? other$custom != null : !this$custom.equals(other$custom)) {
            return false;
        }
        String this$usage = this.usage;
        String other$usage = other.usage;
        if (this$usage == null ? other$usage != null : !this$usage.equals(other$usage)) {
            return false;
        }
        CouponCodeDto this$couponCode = this.couponCode;
        CouponCodeDto other$couponCode = other.couponCode;
        if (this$couponCode == null ? other$couponCode != null : !this$couponCode.equals(other$couponCode)) {
            return false;
        }
        ScarcityDto this$scarcity = this.scarcity;
        ScarcityDto other$scarcity = other.scarcity;
        if (this$scarcity == null ? other$scarcity != null : !((Object)this$scarcity).equals(other$scarcity)) {
            return false;
        }
        BuyCriteriaDto this$buyCriteria = this.buyCriteria;
        BuyCriteriaDto other$buyCriteria = other.buyCriteria;
        if (this$buyCriteria == null ? other$buyCriteria != null : !((Object)this$buyCriteria).equals(other$buyCriteria)) {
            return false;
        }
        RecurrenceDto this$expiration = this.expiration;
        RecurrenceDto other$expiration = other.expiration;
        if (this$expiration == null ? other$expiration != null : !this$expiration.equals(other$expiration)) {
            return false;
        }
        List<CustomFieldValueDto> this$customFields = this.customFields;
        List<CustomFieldValueDto> other$customFields = other.customFields;
        if (this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields)) {
            return false;
        }
        List<CouponTranslationDto> this$translations = this.translations;
        List<CouponTranslationDto> other$translations = other.translations;
        return !(this$translations == null ? other$translations != null : !((Object)this$translations).equals(other$translations));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractCoupon;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $amount = this.amount;
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Boolean $active = this.active;
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $helpMessage = this.helpMessage;
        result = result * 59 + ($helpMessage == null ? 43 : $helpMessage.hashCode());
        String $custom = this.custom;
        result = result * 59 + ($custom == null ? 43 : $custom.hashCode());
        String $usage = this.usage;
        result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
        CouponCodeDto $couponCode = this.couponCode;
        result = result * 59 + ($couponCode == null ? 43 : $couponCode.hashCode());
        ScarcityDto $scarcity = this.scarcity;
        result = result * 59 + ($scarcity == null ? 43 : ((Object)$scarcity).hashCode());
        BuyCriteriaDto $buyCriteria = this.buyCriteria;
        result = result * 59 + ($buyCriteria == null ? 43 : ((Object)$buyCriteria).hashCode());
        RecurrenceDto $expiration = this.expiration;
        result = result * 59 + ($expiration == null ? 43 : $expiration.hashCode());
        List<CustomFieldValueDto> $customFields = this.customFields;
        result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
        List<CouponTranslationDto> $translations = this.translations;
        result = result * 59 + ($translations == null ? 43 : ((Object)$translations).hashCode());
        return result;
    }
}

