/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.coupon;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.data.CustomFieldValueRequestData;
import io.mambo.sdk.service.common.data.DeleteRequestData;
import io.mambo.sdk.service.common.data.FileRequestData;
import io.mambo.sdk.service.common.model.CustomFieldValueDto;
import io.mambo.sdk.service.common.model.response.Status;
import io.mambo.sdk.service.coupon.data.CouponRequestData;
import io.mambo.sdk.service.coupon.data.CouponUserRequestData;
import io.mambo.sdk.service.coupon.model.CouponDto;
import io.mambo.sdk.service.coupon.model.CouponStateDto;
import io.mambo.sdk.service.coupon.param.CouponCloneParams;
import io.mambo.sdk.service.coupon.param.CouponCreateParams;
import io.mambo.sdk.service.coupon.param.CouponCustomFieldParams;
import io.mambo.sdk.service.coupon.param.CouponDeleteParams;
import io.mambo.sdk.service.coupon.param.CouponGetBuyableListParams;
import io.mambo.sdk.service.coupon.param.CouponGetListParams;
import io.mambo.sdk.service.coupon.param.CouponGetParams;
import io.mambo.sdk.service.coupon.param.CouponGetRegularListParams;
import io.mambo.sdk.service.coupon.param.CouponGetStateListParams;
import io.mambo.sdk.service.coupon.param.CouponUpdateParams;
import io.mambo.sdk.service.coupon.param.CouponUploadParams;
import java.io.File;
import java.util.List;

public class CouponsService
extends AbstractService {
    private static final String COUPONS_URI = "/v1/coupons";
    private static final String COUPONS_ID_URI = "/v1/coupons/{couponId}";
    private static final String COUPONS_IMAGE_URI = "/v1/coupons/{couponId}/image";
    private static final String COUPONS_CLONE_URI = "/v1/coupons/{couponId}/clone";
    private static final String COUPONS_CUSTOM_URI = "/v1/coupons/{couponId}/custom_fields";
    private static final String COUPONS_CUSTOM_IMAGE_URI = "/v1/coupons/{couponId}/custom_fields/image";
    private static final String COUPONS_SITE_URI = "/v1/{siteUrl}/coupons";
    private static final String COUPONS_BUYABLE_URI = "/v1/{siteUrl}/coupons/buyable";
    private static final String COUPONS_REGULAR_URI = "/v1/{siteUrl}/coupons/regular";
    private static final String COUPONS_STATE_URI = "/v1/{siteUrl}/coupons/states";
    private static final String VALIDATE_COUPON_URI = "/v1/{siteUrl}/coupons/validate";

    public CouponsService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public CouponDto create(String siteUrl, CouponRequestData data) {
        return this.create(CouponCreateParams.builder().siteUrl(siteUrl).build(), data);
    }

    public CouponDto create(String siteUrl, CouponRequestData data, RequestOptions requestOptions) {
        return this.create(CouponCreateParams.builder().siteUrl(siteUrl).build(), data, requestOptions);
    }

    public CouponDto create(CouponCreateParams params, CouponRequestData data) {
        return this.create(params, data, RequestOptions.create());
    }

    public CouponDto create(CouponCreateParams params, CouponRequestData data, RequestOptions requestOptions) {
        return (CouponDto)this.apiClient().request(ApiRequest.builder().apiPath(COUPONS_SITE_URI).responseClass(CouponDto.class).method(HttpMethod.POST).requestData(data).options(requestOptions).params(params).build());
    }

    public CouponDto update(String couponId, CouponRequestData data) {
        return this.update(CouponUpdateParams.builder().couponId(couponId).build(), data);
    }

    public CouponDto update(CouponUpdateParams params, CouponRequestData data) {
        return this.update(params, data, RequestOptions.create());
    }

    public CouponDto update(CouponUpdateParams params, CouponRequestData data, RequestOptions requestOptions) {
        return (CouponDto)this.apiClient().request(ApiRequest.builder().apiPath(COUPONS_ID_URI).responseClass(CouponDto.class).method(HttpMethod.PUT).requestData(data).options(requestOptions).params(params).build());
    }

    public CouponDto uploadImage(String couponId, File image) {
        return this.uploadImage(CouponUploadParams.builder().couponId(couponId).build(), image);
    }

    public CouponDto uploadImage(CouponUploadParams params, File image) {
        return this.uploadImage(params, image, RequestOptions.create());
    }

    public CouponDto uploadImage(CouponUploadParams params, File image, RequestOptions requestOptions) {
        return (CouponDto)this.apiClient().request(ApiRequest.builder().apiPath(COUPONS_IMAGE_URI).responseClass(CouponDto.class).method(HttpMethod.POST).requestData(new FileRequestData(image)).options(requestOptions).params(params).build());
    }

    public CouponDto clone(String couponId) {
        return this.clone(CouponCloneParams.builder().couponId(couponId).build());
    }

    public CouponDto clone(CouponCloneParams params) {
        return this.clone(params, RequestOptions.create());
    }

    public CouponDto clone(CouponCloneParams params, RequestOptions requestOptions) {
        return (CouponDto)this.apiClient().request(ApiRequest.builder().apiPath(COUPONS_CLONE_URI).responseClass(CouponDto.class).method(HttpMethod.POST).options(requestOptions).params(params).build());
    }

    public Status delete(String couponId) {
        return this.delete(CouponDeleteParams.builder().couponId(couponId).build());
    }

    public Status delete(CouponDeleteParams params) {
        return this.delete(params, RequestOptions.create());
    }

    public Status delete(CouponDeleteParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(COUPONS_ID_URI).responseClass(Status.class).method(HttpMethod.DELETE).options(requestOptions).params(params).build());
    }

    public Status deleteCoupons(DeleteRequestData data) {
        return this.deleteCoupons(data, RequestOptions.create());
    }

    public Status deleteCoupons(DeleteRequestData data, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(COUPONS_URI).responseClass(Status.class).method(HttpMethod.DELETE).requestData(data).options(requestOptions).build());
    }

    public CouponDto get(String couponId) {
        return this.get(CouponGetParams.builder().couponId(couponId).build());
    }

    public CouponDto get(CouponGetParams params) {
        return this.get(params, RequestOptions.create());
    }

    public CouponDto get(CouponGetParams params, RequestOptions requestOptions) {
        return (CouponDto)this.apiClient().request(ApiRequest.builder().apiPath(COUPONS_ID_URI).responseClass(CouponDto.class).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public List<CouponDto> getCoupons(String siteUrl) {
        return this.getCoupons(CouponGetListParams.builder().siteUrl(siteUrl).build());
    }

    public List<CouponDto> getCoupons(CouponGetListParams params) {
        return this.getCoupons(params, RequestOptions.create());
    }

    public List<CouponDto> getCoupons(CouponGetListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(COUPONS_SITE_URI).responseClass(CouponDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public List<CouponDto> getBuyableCoupons(String siteUrl) {
        return this.getBuyableCoupons(CouponGetBuyableListParams.builder().siteUrl(siteUrl).build());
    }

    public List<CouponDto> getBuyableCoupons(CouponGetBuyableListParams params) {
        return this.getBuyableCoupons(params, RequestOptions.create());
    }

    public List<CouponDto> getBuyableCoupons(CouponGetBuyableListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(COUPONS_BUYABLE_URI).responseClass(CouponDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public List<CouponDto> getRegularCoupons(String siteUrl) {
        return this.getRegularCoupons(CouponGetRegularListParams.builder().siteUrl(siteUrl).build());
    }

    public List<CouponDto> getRegularCoupons(CouponGetRegularListParams params) {
        return this.getRegularCoupons(params, RequestOptions.create());
    }

    public List<CouponDto> getRegularCoupons(CouponGetRegularListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(COUPONS_REGULAR_URI).responseClass(CouponDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public List<CouponStateDto> getCouponStates(String siteUrl) {
        return this.getCouponStates(CouponGetStateListParams.builder().siteUrl(siteUrl).build());
    }

    public List<CouponStateDto> getCouponStates(CouponGetStateListParams params) {
        return this.getCouponStates(params, RequestOptions.create());
    }

    public List<CouponStateDto> getCouponStates(CouponGetStateListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(COUPONS_STATE_URI).responseClass(CouponStateDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public Status validateRedeem(String siteUrl, CouponUserRequestData data) {
        return this.validateRedeem(siteUrl, data, RequestOptions.create());
    }

    public Status validateRedeem(String siteUrl, CouponUserRequestData data, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(VALIDATE_COUPON_URI).responseClass(Status.class).method(HttpMethod.POST).requestData(data).options(requestOptions).params(CouponGetListParams.builder().siteUrl(siteUrl).build()).build());
    }

    public CouponRequestData newCouponRequestData() {
        return new CouponRequestData();
    }

    public CouponDto addCustomFields(String couponId, CustomFieldValueRequestData data) {
        CouponCustomFieldParams params = CouponCustomFieldParams.builder().couponId(couponId).build();
        return this.modCustomFields(HttpMethod.POST, params, data, RequestOptions.create());
    }

    public CouponDto addCustomFields(CouponCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.modCustomFields(HttpMethod.POST, params, data, RequestOptions.create());
    }

    public CouponDto updateCustomFields(String couponId, CustomFieldValueRequestData data) {
        CouponCustomFieldParams params = CouponCustomFieldParams.builder().couponId(couponId).build();
        return this.modCustomFields(HttpMethod.PUT, params, data, RequestOptions.create());
    }

    public CouponDto updateCustomFields(CouponCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.modCustomFields(HttpMethod.PUT, params, data, RequestOptions.create());
    }

    public CouponDto deleteCustomFields(String couponId, CustomFieldValueRequestData data) {
        CouponCustomFieldParams params = CouponCustomFieldParams.builder().couponId(couponId).build();
        return this.modCustomFields(HttpMethod.DELETE, params, data, RequestOptions.create());
    }

    public CouponDto deleteCustomFields(CouponCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.modCustomFields(HttpMethod.DELETE, params, data, RequestOptions.create());
    }

    private CouponDto modCustomFields(HttpMethod method, CouponCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return (CouponDto)this.apiClient().request(ApiRequest.builder().apiPath(COUPONS_CUSTOM_URI).responseClass(CouponDto.class).method(method).params(params).options(requestOptions).requestData(data).build());
    }

    public CouponDto addCustomField(String couponId, CustomFieldValueDto data, File image) {
        return this.addCustomField(couponId, data, image, RequestOptions.create());
    }

    public CouponDto addCustomField(String couponId, CustomFieldValueDto data, File image, RequestOptions requestOptions) {
        CouponCustomFieldParams params = CouponCustomFieldParams.builder().couponId(couponId).build();
        return this.addCustomField(params, data, image, requestOptions);
    }

    public CouponDto addCustomField(CouponCustomFieldParams params, CustomFieldValueDto data, File image) {
        return this.addCustomField(params, data, image, RequestOptions.create());
    }

    public CouponDto addCustomField(CouponCustomFieldParams params, CustomFieldValueDto data, File image, RequestOptions requestOptions) {
        return (CouponDto)this.apiClient().request(ApiRequest.builder().apiPath(COUPONS_CUSTOM_IMAGE_URI).responseClass(CouponDto.class).method(HttpMethod.POST).params(params).options(requestOptions).requestData(new FileRequestData(image, data)).build());
    }
}

