/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.common.model.response;

import io.mambo.sdk.exception.MamboApiException;
import io.mambo.sdk.exception.MamboExceptionFactory;
import io.mambo.sdk.http.HttpStatus;
import io.mambo.sdk.utils.StringUtils;

public class ProcessingStatusDto {
    private static MamboExceptionFactory exceptionFactory = new MamboExceptionFactory();
    private String status;
    private String exceptionMessage;
    private Integer exceptionCode;

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exception) {
        this.exceptionMessage = exception;
    }

    public Integer getExceptionCode() {
        return this.exceptionCode;
    }

    public void setExceptionCode(Integer exceptionCode) {
        this.exceptionCode = exceptionCode;
    }

    public HttpStatus getExceptionStatus() {
        if (this.exceptionCode == null) {
            return null;
        }
        return HttpStatus.valueOf(this.exceptionCode);
    }

    public MamboApiException getException() {
        if (this.exceptionMessage == null || this.exceptionCode == null) {
            return null;
        }
        return exceptionFactory.createMamboApiException(this.exceptionMessage, this.getExceptionStatus());
    }

    public boolean isNotProccessed() {
        return StringUtils.equals("NotProcessed", this.getStatus());
    }

    public boolean isFailed() {
        return StringUtils.equals("Failed", this.getStatus());
    }

    public boolean isSuccess() {
        return StringUtils.equals("Success", this.getStatus());
    }

    public boolean isProcessing() {
        return StringUtils.equals("Processing", this.getStatus());
    }
}

