/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.behaviour.model.metadata;

import io.mambo.sdk.utils.StringUtils;

public enum MetadataOperator {
    GREATER_THAN("$gt"),
    GREATER_THAN_OR_EQUAL_TO("$gte"),
    LESS_THAN("$lt"),
    LESS_THAN_OR_EQUAL_TO("$lte"),
    ON("$on"),
    NOT_ON("$non"),
    AFTER("$after"),
    ON_OR_AFTER("$onafter"),
    BEFORE("$before"),
    ON_OR_BEFORE("$onbefore"),
    EQUAL_TO("$eq"),
    NOT_EQUAL_TO("$neq"),
    CONTAINS("$in"),
    NOT_CONTAINS("$nin"),
    STARTS_WITH("$sw"),
    NOT_STARTS_WITH("$nsw"),
    ENDS_WITH("$ew"),
    NOT_ENDS_WITH("$new");

    private String type;

    private MetadataOperator(String type) {
        this.type = type;
    }

    public String value() {
        return this.type;
    }

    public Boolean isGreaterThan() {
        return this == GREATER_THAN;
    }

    public Boolean isGreaterThanOrEqualTo() {
        return this == GREATER_THAN_OR_EQUAL_TO;
    }

    public Boolean isLessThan() {
        return this == LESS_THAN;
    }

    public Boolean isLessThanOrEqualTo() {
        return this == LESS_THAN_OR_EQUAL_TO;
    }

    public Boolean isOn() {
        return this == ON;
    }

    public Boolean isNotOn() {
        return this == NOT_ON;
    }

    public Boolean isAfter() {
        return this == AFTER;
    }

    public Boolean isOnOrAfter() {
        return this == ON_OR_AFTER;
    }

    public Boolean isBefore() {
        return this == BEFORE;
    }

    public Boolean isOnOrBefore() {
        return this == ON_OR_BEFORE;
    }

    public Boolean isEqualTo() {
        return this == EQUAL_TO;
    }

    public Boolean isNotEqualTo() {
        return this == NOT_EQUAL_TO;
    }

    public Boolean isContains() {
        return this == CONTAINS;
    }

    public Boolean isNotContains() {
        return this == NOT_CONTAINS;
    }

    public Boolean isStartsWith() {
        return this == STARTS_WITH;
    }

    public Boolean isNotStartsWith() {
        return this == NOT_STARTS_WITH;
    }

    public Boolean isEndsWith() {
        return this == ENDS_WITH;
    }

    public Boolean isNotEndsWith() {
        return this == NOT_ENDS_WITH;
    }

    public Boolean isNumeric() {
        return this.isGreaterThan() != false || this.isGreaterThanOrEqualTo() != false || this.isLessThan() != false || this.isLessThanOrEqualTo() != false;
    }

    public Boolean isDate() {
        return this.isOn() != false || this.isNotOn() != false || this.isAfter() != false || this.isOnOrAfter() != false || this.isBefore() != false || this.isOnOrBefore() != false;
    }

    public static MetadataOperator fromString(String type) {
        if (StringUtils.isEmpty(type)) {
            throw new IllegalArgumentException("MetadataOperator type cannot be empty");
        }
        for (MetadataOperator ps : MetadataOperator.values()) {
            if (!type.equalsIgnoreCase(ps.type)) continue;
            return ps;
        }
        return null;
    }
}

