/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.behaviour;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.behaviour.data.BehaviourRequestData;
import io.mambo.sdk.service.behaviour.model.BehaviourDto;
import io.mambo.sdk.service.behaviour.param.BehaviourCloneParams;
import io.mambo.sdk.service.behaviour.param.BehaviourCreateParams;
import io.mambo.sdk.service.behaviour.param.BehaviourCustomFieldParams;
import io.mambo.sdk.service.behaviour.param.BehaviourDeleteParams;
import io.mambo.sdk.service.behaviour.param.BehaviourGetFlexibleListParams;
import io.mambo.sdk.service.behaviour.param.BehaviourGetListParams;
import io.mambo.sdk.service.behaviour.param.BehaviourGetParams;
import io.mambo.sdk.service.behaviour.param.BehaviourGetSimpleListParams;
import io.mambo.sdk.service.behaviour.param.BehaviourUpdateParams;
import io.mambo.sdk.service.behaviour.param.BehaviourUploadParams;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.data.CustomFieldValueRequestData;
import io.mambo.sdk.service.common.data.DeleteRequestData;
import io.mambo.sdk.service.common.data.FileRequestData;
import io.mambo.sdk.service.common.model.CustomFieldValueDto;
import io.mambo.sdk.service.common.model.response.Status;
import java.io.File;
import java.util.List;

public class BehavioursService
extends AbstractService {
    private static final String BEHAVIOURS_URI = "/v1/behaviours";
    private static final String BEHAVIOURS_ID_URI = "/v1/behaviours/{behaviourId}";
    private static final String BEHAVIOURS_IMAGE_URI = "/v1/behaviours/{behaviourId}/image";
    private static final String BEHAVIOURS_CLONE_URI = "/v1/behaviours/{behaviourId}/clone";
    private static final String BEHAVIOURS_CUSTOM_URI = "/v1/behaviours/{behaviourId}/custom_fields";
    private static final String BEHAVIOURS_CUSTOM_IMAGE_URI = "/v1/behaviours/{behaviourId}/custom_fields/image";
    private static final String BEHAVIOURS_SITE_URI = "/v1/{siteUrl}/behaviours";
    private static final String SIMPLE_BEHAVIOURS_SITE_URI = "/v1/{siteUrl}/behaviours/simple";
    private static final String FLEX_BEHAVIOURS_SITE_URI = "/v1/{siteUrl}/behaviours/flexible";

    public BehavioursService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    public BehaviourDto create(String siteUrl, BehaviourRequestData data) {
        return this.create(BehaviourCreateParams.builder().siteUrl(siteUrl).build(), data);
    }

    public BehaviourDto create(String siteUrl, BehaviourRequestData data, RequestOptions requestOptions) {
        return this.create(BehaviourCreateParams.builder().siteUrl(siteUrl).build(), data, requestOptions);
    }

    public BehaviourDto create(BehaviourCreateParams params, BehaviourRequestData data) {
        return this.create(params, data, RequestOptions.create());
    }

    public BehaviourDto create(BehaviourCreateParams params, BehaviourRequestData data, RequestOptions requestOptions) {
        return (BehaviourDto)this.apiClient().request(ApiRequest.builder().apiPath(BEHAVIOURS_SITE_URI).responseClass(BehaviourDto.class).method(HttpMethod.POST).requestData(data).options(requestOptions).params(params).build());
    }

    public BehaviourDto update(String behaviourId, BehaviourRequestData data) {
        return this.update(BehaviourUpdateParams.builder().behaviourId(behaviourId).build(), data, RequestOptions.create());
    }

    public BehaviourDto update(BehaviourUpdateParams params, BehaviourRequestData data) {
        return this.update(params, data, RequestOptions.create());
    }

    public BehaviourDto update(BehaviourUpdateParams params, BehaviourRequestData data, RequestOptions requestOptions) {
        return (BehaviourDto)this.apiClient().request(ApiRequest.builder().apiPath(BEHAVIOURS_ID_URI).responseClass(BehaviourDto.class).method(HttpMethod.PUT).requestData(data).options(requestOptions).params(params).build());
    }

    public BehaviourDto uploadImage(String behaviourId, File image) {
        return this.uploadImage(BehaviourUploadParams.builder().behaviourId(behaviourId).build(), image, RequestOptions.create());
    }

    public BehaviourDto uploadImage(BehaviourUploadParams params, File image) {
        return this.uploadImage(params, image, RequestOptions.create());
    }

    public BehaviourDto uploadImage(BehaviourUploadParams params, File image, RequestOptions requestOptions) {
        return (BehaviourDto)this.apiClient().request(ApiRequest.builder().apiPath(BEHAVIOURS_IMAGE_URI).responseClass(BehaviourDto.class).method(HttpMethod.POST).requestData(new FileRequestData(image)).options(requestOptions).params(params).build());
    }

    public BehaviourDto clone(String behaviourId) {
        return this.clone(BehaviourCloneParams.builder().behaviourId(behaviourId).build(), RequestOptions.create());
    }

    public BehaviourDto clone(BehaviourCloneParams params) {
        return this.clone(params, RequestOptions.create());
    }

    public BehaviourDto clone(BehaviourCloneParams params, RequestOptions requestOptions) {
        return (BehaviourDto)this.apiClient().request(ApiRequest.builder().apiPath(BEHAVIOURS_CLONE_URI).responseClass(BehaviourDto.class).method(HttpMethod.POST).options(requestOptions).params(params).build());
    }

    public Status delete(String behaviourId) {
        return this.delete(BehaviourDeleteParams.builder().behaviourId(behaviourId).build(), RequestOptions.create());
    }

    public Status delete(BehaviourDeleteParams params) {
        return this.delete(params, RequestOptions.create());
    }

    public Status delete(BehaviourDeleteParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(BEHAVIOURS_ID_URI).responseClass(Status.class).method(HttpMethod.DELETE).options(requestOptions).params(params).build());
    }

    public BehaviourDto get(String behaviourId) {
        return this.get(BehaviourGetParams.builder().behaviourId(behaviourId).build(), RequestOptions.create());
    }

    public BehaviourDto get(BehaviourGetParams params) {
        return this.get(params, RequestOptions.create());
    }

    public BehaviourDto get(BehaviourGetParams params, RequestOptions requestOptions) {
        return (BehaviourDto)this.apiClient().request(ApiRequest.builder().apiPath(BEHAVIOURS_ID_URI).responseClass(BehaviourDto.class).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public Status deleteBehaviours(DeleteRequestData data) {
        return this.deleteBehaviours(data, RequestOptions.create());
    }

    public Status deleteBehaviours(DeleteRequestData data, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(BEHAVIOURS_URI).responseClass(Status.class).method(HttpMethod.DELETE).requestData(data).options(requestOptions).build());
    }

    public List<BehaviourDto> getBehaviours(String siteUrl) {
        return this.getBehaviours(BehaviourGetListParams.builder().siteUrl(siteUrl).build(), RequestOptions.create());
    }

    public List<BehaviourDto> getBehaviours(BehaviourGetListParams params) {
        return this.getBehaviours(params, RequestOptions.create());
    }

    public List<BehaviourDto> getBehaviours(BehaviourGetListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(BEHAVIOURS_SITE_URI).responseClass(BehaviourDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public List<BehaviourDto> getSimpleBehaviours(String siteUrl) {
        return this.getSimpleBehaviours(BehaviourGetSimpleListParams.builder().siteUrl(siteUrl).build(), RequestOptions.create());
    }

    public List<BehaviourDto> getSimpleBehaviours(BehaviourGetSimpleListParams params) {
        return this.getSimpleBehaviours(params, RequestOptions.create());
    }

    public List<BehaviourDto> getSimpleBehaviours(BehaviourGetSimpleListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(SIMPLE_BEHAVIOURS_SITE_URI).responseClass(BehaviourDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public List<BehaviourDto> getFlexibleBehaviours(String siteUrl) {
        return this.getFlexibleBehaviours(BehaviourGetFlexibleListParams.builder().siteUrl(siteUrl).build(), RequestOptions.create());
    }

    public List<BehaviourDto> getFlexibleBehaviours(BehaviourGetFlexibleListParams params) {
        return this.getFlexibleBehaviours(params, RequestOptions.create());
    }

    public List<BehaviourDto> getFlexibleBehaviours(BehaviourGetFlexibleListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(FLEX_BEHAVIOURS_SITE_URI).responseClass(BehaviourDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public BehaviourDto addCustomFields(String behaviourId, CustomFieldValueRequestData data) {
        return this.addCustomFields(BehaviourCustomFieldParams.builder().behaviourId(behaviourId).build(), data, RequestOptions.create());
    }

    public BehaviourDto addCustomFields(BehaviourCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.addCustomFields(params, data, RequestOptions.create());
    }

    public BehaviourDto addCustomFields(BehaviourCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return this.modCustomFields(HttpMethod.POST, params, data, requestOptions);
    }

    public BehaviourDto updateCustomFields(String behaviourId, CustomFieldValueRequestData data) {
        return this.updateCustomFields(BehaviourCustomFieldParams.builder().behaviourId(behaviourId).build(), data, RequestOptions.create());
    }

    public BehaviourDto updateCustomFields(BehaviourCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.updateCustomFields(params, data, RequestOptions.create());
    }

    public BehaviourDto updateCustomFields(BehaviourCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return this.modCustomFields(HttpMethod.PUT, params, data, requestOptions);
    }

    public BehaviourDto deleteCustomFields(String behaviourId, CustomFieldValueRequestData data) {
        return this.deleteCustomFields(BehaviourCustomFieldParams.builder().behaviourId(behaviourId).build(), data, RequestOptions.create());
    }

    public BehaviourDto deleteCustomFields(BehaviourCustomFieldParams params, CustomFieldValueRequestData data) {
        return this.deleteCustomFields(params, data, RequestOptions.create());
    }

    public BehaviourDto deleteCustomFields(BehaviourCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return this.modCustomFields(HttpMethod.DELETE, params, data, requestOptions);
    }

    private BehaviourDto modCustomFields(HttpMethod method, BehaviourCustomFieldParams params, CustomFieldValueRequestData data, RequestOptions requestOptions) {
        return (BehaviourDto)this.apiClient().request(ApiRequest.builder().apiPath(BEHAVIOURS_CUSTOM_URI).responseClass(BehaviourDto.class).method(method).params(params).requestData(data).options(requestOptions).build());
    }

    public BehaviourDto addCustomField(String behaviourId, CustomFieldValueDto data, File image) {
        return this.addCustomField(BehaviourCustomFieldParams.builder().behaviourId(behaviourId).build(), data, image, RequestOptions.create());
    }

    public BehaviourDto addCustomField(BehaviourCustomFieldParams params, CustomFieldValueDto data, File image) {
        return this.addCustomField(params, data, image, RequestOptions.create());
    }

    public BehaviourDto addCustomField(BehaviourCustomFieldParams params, CustomFieldValueDto data, File image, RequestOptions requestOptions) {
        return (BehaviourDto)this.apiClient().request(ApiRequest.builder().apiPath(BEHAVIOURS_CUSTOM_IMAGE_URI).responseClass(BehaviourDto.class).method(HttpMethod.POST).params(params).requestData(new FileRequestData(image, data)).options(requestOptions).build());
    }

    public BehaviourRequestData newBehaviourRequestData() {
        return new BehaviourRequestData();
    }
}

