/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.analytics.param;

import io.mambo.sdk.service.common.param.AbstractServiceParamsBuilder;
import io.mambo.sdk.service.common.param.ServiceParams;
import io.mambo.sdk.utils.Multimap;
import io.mambo.sdk.utils.Preconditions;

public class AnalyticsGetListParams
implements ServiceParams {
    private Multimap<String, String> params = new Multimap();

    private AnalyticsGetListParams(Builder builder) {
        this.params = builder.params();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Multimap<String, String> asMap() {
        return this.params;
    }

    public static class Builder
    extends AbstractServiceParamsBuilder<Builder> {
        public Builder siteUrl(String siteUrl) {
            Preconditions.checkNotNull(siteUrl, "siteUrl must not be null");
            this.params.put("siteUrl", siteUrl);
            return this;
        }

        public Builder page(int page) {
            this.params.put("page", String.valueOf(page));
            return this;
        }

        public Builder count(int count) {
            this.params.put("count", String.valueOf(count));
            return this;
        }

        public Builder dataType(String dataType) {
            this.params.put("dataType", dataType);
            return this;
        }

        public Builder reportType(String reportType) {
            this.params.put("reportType", reportType);
            return this;
        }

        public Builder startDate(String startDate) {
            this.params.put("startDate", startDate);
            return this;
        }

        public Builder endDate(String endDate) {
            this.params.put("endDate", endDate);
            return this;
        }

        public Builder tag(String tag) {
            this.params.put("tag", tag);
            return this;
        }

        public AnalyticsGetListParams build() {
            Preconditions.checkContainsKey(this.params, "siteUrl", "siteUrl must not be null");
            return new AnalyticsGetListParams(this);
        }

        private Multimap<String, String> params() {
            return this.params;
        }
    }
}

