/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.activity.model;

import io.mambo.sdk.service.activity.model.AbstractActivity;
import io.mambo.sdk.service.activity.model.UserTagsDto;
import io.mambo.sdk.service.common.model.awarded.AwardedCouponDto;
import io.mambo.sdk.service.common.model.awarded.AwardedDto;
import io.mambo.sdk.service.common.model.awarded.AwardedKpiDto;
import io.mambo.sdk.service.common.model.awarded.AwardedPointDto;
import io.mambo.sdk.service.common.model.awarded.AwardedRewardDto;
import io.mambo.sdk.service.common.model.interfaces.AggregateDto;
import io.mambo.sdk.service.common.model.interfaces.HasId;
import io.mambo.sdk.service.common.model.tag.HasTags;
import io.mambo.sdk.service.tag.model.TagDto;
import io.mambo.sdk.service.user.model.UserDto;
import io.mambo.sdk.utils.ListUtils;
import io.mambo.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class ActivityDto
extends AbstractActivity
implements AggregateDto,
HasTags,
HasId {
    private String id;
    private String userId;
    private String createdOn;
    private String modifiedOn;
    private String rejectedReason;
    private String state;
    private String systemInfo;
    private UserDto user;
    private UserTagsDto userTags;
    private List<TagDto> tags;
    private List<String> tagIds;
    private List<String> rewardIds = new ArrayList<String>();
    private List<AwardedDto> awarded = new ArrayList<AwardedDto>();
    private List<AwardedKpiDto> kpis = new ArrayList<AwardedKpiDto>();
    private List<AwardedRewardDto> rewards = new ArrayList<AwardedRewardDto>();
    private List<AwardedPointDto> points = new ArrayList<AwardedPointDto>();
    private List<AwardedCouponDto> coupons = new ArrayList<AwardedCouponDto>();

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getSystemInfo() {
        return this.systemInfo;
    }

    public void setSystemInfo(String systemInfo) {
        this.systemInfo = systemInfo;
    }

    public UserTagsDto getUserTags() {
        return this.userTags;
    }

    public void setUserTags(UserTagsDto userTags) {
        this.userTags = userTags;
    }

    public List<AwardedDto> getAwarded() {
        return this.awarded;
    }

    public void setAwarded(List<AwardedDto> awarded) {
        this.awarded = awarded;
    }

    public List<AwardedRewardDto> getRewards() {
        if (ListUtils.isEmpty(this.awarded)) {
            return this.rewards;
        }
        if (ListUtils.isNotEmpty(this.rewards)) {
            return this.rewards;
        }
        for (AwardedDto awd : this.awarded) {
            if (!StringUtils.equals("reward", awd.getAwardedType())) continue;
            this.rewards.add((AwardedRewardDto)awd);
        }
        return this.rewards;
    }

    public List<AwardedKpiDto> getKpis() {
        if (ListUtils.isEmpty(this.awarded)) {
            return this.kpis;
        }
        if (ListUtils.isNotEmpty(this.kpis)) {
            return this.kpis;
        }
        for (AwardedDto awd : this.awarded) {
            if (!StringUtils.equals("kpi", awd.getAwardedType())) continue;
            this.kpis.add((AwardedKpiDto)awd);
        }
        return this.kpis;
    }

    public List<String> getRewardIds() {
        return this.rewardIds;
    }

    public void setRewardIds(List<String> rewardIds) {
        this.rewardIds = rewardIds;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public String getModifiedOn() {
        return this.modifiedOn;
    }

    public void setModifiedOn(String modifiedOn) {
        this.modifiedOn = modifiedOn;
    }

    public String getRejectedReason() {
        return this.rejectedReason;
    }

    public void setRejectedReason(String rejectedReason) {
        this.rejectedReason = rejectedReason;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public List<AwardedPointDto> getPoints() {
        return this.points;
    }

    public void setPoints(List<AwardedPointDto> points) {
        this.points = points;
    }

    public List<AwardedCouponDto> getCoupons() {
        return this.coupons;
    }

    public void setCoupons(List<AwardedCouponDto> coupons) {
        this.coupons = coupons;
    }

    @Override
    public List<String> getTagIds() {
        return this.tagIds;
    }

    @Override
    public void setTagIds(List<String> tagIds) {
        this.tagIds = tagIds;
    }

    @Override
    public List<TagDto> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(List<TagDto> tags) {
        this.tags = tags;
    }

    public UserDto getUser() {
        return this.user;
    }

    public void setUser(UserDto user) {
        this.user = user;
    }

    @Override
    @Generated
    public String toString() {
        return "ActivityDto(super=" + super.toString() + ", id=" + this.id + ", userId=" + this.userId + ", createdOn=" + this.createdOn + ", modifiedOn=" + this.modifiedOn + ", rejectedReason=" + this.rejectedReason + ", state=" + this.state + ", systemInfo=" + this.systemInfo + ", user=" + this.user + ", userTags=" + this.userTags + ", tags=" + this.tags + ", tagIds=" + this.tagIds + ", rewardIds=" + this.rewardIds + ", awarded=" + this.awarded + ", kpis=" + this.kpis + ", rewards=" + this.rewards + ", points=" + this.points + ", coupons=" + this.coupons + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivityDto)) {
            return false;
        }
        ActivityDto other = (ActivityDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$userId = this.userId;
        String other$userId = other.userId;
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$createdOn = this.createdOn;
        String other$createdOn = other.createdOn;
        if (this$createdOn == null ? other$createdOn != null : !this$createdOn.equals(other$createdOn)) {
            return false;
        }
        String this$modifiedOn = this.modifiedOn;
        String other$modifiedOn = other.modifiedOn;
        if (this$modifiedOn == null ? other$modifiedOn != null : !this$modifiedOn.equals(other$modifiedOn)) {
            return false;
        }
        String this$rejectedReason = this.rejectedReason;
        String other$rejectedReason = other.rejectedReason;
        if (this$rejectedReason == null ? other$rejectedReason != null : !this$rejectedReason.equals(other$rejectedReason)) {
            return false;
        }
        String this$state = this.state;
        String other$state = other.state;
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$systemInfo = this.systemInfo;
        String other$systemInfo = other.systemInfo;
        if (this$systemInfo == null ? other$systemInfo != null : !this$systemInfo.equals(other$systemInfo)) {
            return false;
        }
        UserDto this$user = this.user;
        UserDto other$user = other.user;
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        UserTagsDto this$userTags = this.userTags;
        UserTagsDto other$userTags = other.userTags;
        if (this$userTags == null ? other$userTags != null : !((Object)this$userTags).equals(other$userTags)) {
            return false;
        }
        List<TagDto> this$tags = this.tags;
        List<TagDto> other$tags = other.tags;
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<String> this$tagIds = this.tagIds;
        List<String> other$tagIds = other.tagIds;
        if (this$tagIds == null ? other$tagIds != null : !((Object)this$tagIds).equals(other$tagIds)) {
            return false;
        }
        List<String> this$rewardIds = this.rewardIds;
        List<String> other$rewardIds = other.rewardIds;
        if (this$rewardIds == null ? other$rewardIds != null : !((Object)this$rewardIds).equals(other$rewardIds)) {
            return false;
        }
        List<AwardedDto> this$awarded = this.awarded;
        List<AwardedDto> other$awarded = other.awarded;
        if (this$awarded == null ? other$awarded != null : !((Object)this$awarded).equals(other$awarded)) {
            return false;
        }
        List<AwardedKpiDto> this$kpis = this.kpis;
        List<AwardedKpiDto> other$kpis = other.kpis;
        if (this$kpis == null ? other$kpis != null : !((Object)this$kpis).equals(other$kpis)) {
            return false;
        }
        List<AwardedRewardDto> this$rewards = this.rewards;
        List<AwardedRewardDto> other$rewards = other.rewards;
        if (this$rewards == null ? other$rewards != null : !((Object)this$rewards).equals(other$rewards)) {
            return false;
        }
        List<AwardedPointDto> this$points = this.points;
        List<AwardedPointDto> other$points = other.points;
        if (this$points == null ? other$points != null : !((Object)this$points).equals(other$points)) {
            return false;
        }
        List<AwardedCouponDto> this$coupons = this.coupons;
        List<AwardedCouponDto> other$coupons = other.coupons;
        return !(this$coupons == null ? other$coupons != null : !((Object)this$coupons).equals(other$coupons));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ActivityDto;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $userId = this.userId;
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $createdOn = this.createdOn;
        result = result * 59 + ($createdOn == null ? 43 : $createdOn.hashCode());
        String $modifiedOn = this.modifiedOn;
        result = result * 59 + ($modifiedOn == null ? 43 : $modifiedOn.hashCode());
        String $rejectedReason = this.rejectedReason;
        result = result * 59 + ($rejectedReason == null ? 43 : $rejectedReason.hashCode());
        String $state = this.state;
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $systemInfo = this.systemInfo;
        result = result * 59 + ($systemInfo == null ? 43 : $systemInfo.hashCode());
        UserDto $user = this.user;
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        UserTagsDto $userTags = this.userTags;
        result = result * 59 + ($userTags == null ? 43 : ((Object)$userTags).hashCode());
        List<TagDto> $tags = this.tags;
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<String> $tagIds = this.tagIds;
        result = result * 59 + ($tagIds == null ? 43 : ((Object)$tagIds).hashCode());
        List<String> $rewardIds = this.rewardIds;
        result = result * 59 + ($rewardIds == null ? 43 : ((Object)$rewardIds).hashCode());
        List<AwardedDto> $awarded = this.awarded;
        result = result * 59 + ($awarded == null ? 43 : ((Object)$awarded).hashCode());
        List<AwardedKpiDto> $kpis = this.kpis;
        result = result * 59 + ($kpis == null ? 43 : ((Object)$kpis).hashCode());
        List<AwardedRewardDto> $rewards = this.rewards;
        result = result * 59 + ($rewards == null ? 43 : ((Object)$rewards).hashCode());
        List<AwardedPointDto> $points = this.points;
        result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
        List<AwardedCouponDto> $coupons = this.coupons;
        result = result * 59 + ($coupons == null ? 43 : ((Object)$coupons).hashCode());
        return result;
    }
}

