/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.activity.model;

import io.mambo.sdk.service.activity.model.ContentDto;
import io.mambo.sdk.service.activity.model.attributes.ActivityAttrs;
import io.mambo.sdk.service.common.data.RequestData;
import io.mambo.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public abstract class AbstractActivity
implements RequestData {
    protected transient List<String> initializedFields = new ArrayList<String>();
    private String url;
    private String reason;
    private ContentDto content;
    private ContentDto target;
    private ActivityAttrs attrs;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.initializedFields.add("url");
        this.url = url;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.initializedFields.add("reason");
        this.reason = reason;
    }

    public ContentDto getContent() {
        return this.content;
    }

    public void setContent(ContentDto content) {
        this.initializedFields.add("content");
        this.content = content;
    }

    public ContentDto getTarget() {
        return this.target;
    }

    public void setTarget(ContentDto target) {
        this.initializedFields.add("target");
        this.target = target;
    }

    public ActivityAttrs getAttrs() {
        return this.attrs;
    }

    public void setAttrs(ActivityAttrs attrs) {
        this.initializedFields.add("attrs");
        this.attrs = attrs;
    }

    public Boolean isBehaviour() {
        if (this.attrs == null) {
            return false;
        }
        return ActivityType.BEHAVIOUR.isValue(this.attrs.getType());
    }

    public Boolean isCoupon() {
        if (this.attrs == null) {
            return false;
        }
        return ActivityType.COUPON.isValue(this.attrs.getType());
    }

    public Boolean isPoint() {
        if (this.attrs == null) {
            return false;
        }
        return ActivityType.POINT.isValue(this.attrs.getType());
    }

    public Boolean isBounty() {
        if (this.attrs == null) {
            return false;
        }
        return ActivityType.BOUNTY.isValue(this.attrs.getType());
    }

    public Boolean isGifted() {
        if (this.attrs == null) {
            return false;
        }
        return ActivityType.GIFTED.isValue(this.attrs.getType());
    }

    public Boolean isKPI() {
        if (this.attrs == null) {
            return false;
        }
        return ActivityType.KPI.isValue(this.attrs.getType());
    }

    @Override
    public List<String> getInitializedFields() {
        return this.initializedFields;
    }

    @Generated
    public String toString() {
        return "AbstractActivity(initializedFields=" + this.initializedFields + ", url=" + this.url + ", reason=" + this.reason + ", content=" + this.content + ", target=" + this.target + ", attrs=" + this.attrs + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractActivity)) {
            return false;
        }
        AbstractActivity other = (AbstractActivity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.url;
        String other$url = other.url;
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$reason = this.reason;
        String other$reason = other.reason;
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        ContentDto this$content = this.content;
        ContentDto other$content = other.content;
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        ContentDto this$target = this.target;
        ContentDto other$target = other.target;
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        ActivityAttrs this$attrs = this.attrs;
        ActivityAttrs other$attrs = other.attrs;
        return !(this$attrs == null ? other$attrs != null : !this$attrs.equals(other$attrs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractActivity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.url;
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $reason = this.reason;
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        ContentDto $content = this.content;
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        ContentDto $target = this.target;
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        ActivityAttrs $attrs = this.attrs;
        result = result * 59 + ($attrs == null ? 43 : $attrs.hashCode());
        return result;
    }

    public static enum ActivityType {
        BEHAVIOUR("behaviour"),
        COUPON("coupon"),
        POINT("point"),
        BOUNTY("bounty"),
        GIFTED("gifted"),
        KPI("kpi");

        private String value;

        private ActivityType(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public Boolean isValue(String other) {
            return StringUtils.equals(this.value, other);
        }
    }
}

