/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.service.activity;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.service.activity.data.ActivityRequestData;
import io.mambo.sdk.service.activity.data.RejectActivityCriteriaRequestData;
import io.mambo.sdk.service.activity.data.RejectActivityRequestData;
import io.mambo.sdk.service.activity.model.ActivityDto;
import io.mambo.sdk.service.activity.param.ActivityBountyAwardParams;
import io.mambo.sdk.service.activity.param.ActivityBountyCancelParams;
import io.mambo.sdk.service.activity.param.ActivityCreateParams;
import io.mambo.sdk.service.activity.param.ActivityGetListByUserParams;
import io.mambo.sdk.service.activity.param.ActivityGetListParams;
import io.mambo.sdk.service.activity.param.ActivityGetParams;
import io.mambo.sdk.service.activity.param.ActivityProcessingStatusParams;
import io.mambo.sdk.service.activity.param.ActivityRejectBulkParams;
import io.mambo.sdk.service.activity.param.ActivityRejectParams;
import io.mambo.sdk.service.common.AbstractService;
import io.mambo.sdk.service.common.model.AggregateId;
import io.mambo.sdk.service.common.model.response.ProcessingStatusDto;
import io.mambo.sdk.service.common.model.response.RejectActivityBulkResponse;
import io.mambo.sdk.service.common.model.response.Status;
import java.util.List;

public class ActivitiesService
extends AbstractService {
    private static final String ACTIVITIES_SITE_URI = "/v1/{siteUrl}/activities";
    private static final String ACTIVITIES_SITE_URI_V2 = "/v2/{siteUrl}/activities";
    private static final String ACTIVITIES_USER_URI = "/v1/{siteUrl}/activities/{uuid}";
    private static final String ACTIVITIES_ID_URI = "/v1/activities/{activityId}";
    private static final String ACTIVITIES_REJECT_URI = "/v1/activities/{activityId}/reject";
    private static final String ACTIVITIES_BULK_REJECT_URI = "/v1/{siteUrl}/activities/reject";
    private static final String ACTIVITIES_BOUNTY_CANCEL_URI = "/v1/activities/{activityId}/bounty/cancel";
    private static final String ACTIVITIES_BOUNTY_AWARD_URI = "/v1/activities/{activityId}/bounty/award/{uuid}";
    private static final String ACTIVITIES_STATUS_URI = "/v2/activities/{activityId}/status";

    public ActivitiesService(ApiRequestAdapter apiClient) {
        super(apiClient);
    }

    @Deprecated
    public AggregateId create(String siteUrl, ActivityRequestData data) {
        return this.create(siteUrl, data, RequestOptions.create());
    }

    @Deprecated
    public AggregateId create(String siteUrl, ActivityRequestData data, RequestOptions requestOptions) {
        return this.create(ActivityCreateParams.builder().siteUrl(siteUrl).build(), data, requestOptions);
    }

    @Deprecated
    public AggregateId create(ActivityCreateParams params, ActivityRequestData data, RequestOptions requestOptions) {
        return (AggregateId)this.apiClient().request(ApiRequest.builder().apiPath(ACTIVITIES_SITE_URI).responseClass(AggregateId.class).method(HttpMethod.POST).options(requestOptions).requestData(data).params(params).build());
    }

    public AggregateId createAsync(String siteUrl, ActivityRequestData data) {
        return this.createAsync(siteUrl, data, RequestOptions.create());
    }

    public AggregateId createAsync(String siteUrl, ActivityRequestData data, RequestOptions requestOptions) {
        return this.createAsync(ActivityCreateParams.builder().siteUrl(siteUrl).build(), data, requestOptions);
    }

    public AggregateId createAsync(ActivityCreateParams params, ActivityRequestData data, RequestOptions requestOptions) {
        return (AggregateId)this.apiClient().request(ApiRequest.builder().apiPath(ACTIVITIES_SITE_URI_V2).responseClass(AggregateId.class).method(HttpMethod.POST).options(requestOptions).requestData(data).params(params).build());
    }

    public Status reject(String activityId, RejectActivityRequestData data) {
        return this.reject(ActivityRejectParams.builder().activityId(activityId).build(), data, RequestOptions.create());
    }

    public Status reject(ActivityRejectParams params, RejectActivityRequestData data) {
        return this.reject(params, data, RequestOptions.create());
    }

    public Status reject(ActivityRejectParams params, RejectActivityRequestData data, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(ACTIVITIES_REJECT_URI).responseClass(Status.class).method(HttpMethod.POST).options(requestOptions).requestData(data).params(params).build());
    }

    public RejectActivityBulkResponse rejectBulk(String siteUrl, RejectActivityCriteriaRequestData data) {
        return this.rejectBulk(ActivityRejectBulkParams.builder().siteUrl(siteUrl).build(), data, RequestOptions.create());
    }

    public RejectActivityBulkResponse rejectBulk(ActivityRejectBulkParams params, RejectActivityCriteriaRequestData data) {
        return this.rejectBulk(params, data, RequestOptions.create());
    }

    public RejectActivityBulkResponse rejectBulk(ActivityRejectBulkParams params, RejectActivityCriteriaRequestData data, RequestOptions requestOptions) {
        return (RejectActivityBulkResponse)this.apiClient().request(ApiRequest.builder().apiPath(ACTIVITIES_BULK_REJECT_URI).responseClass(RejectActivityBulkResponse.class).method(HttpMethod.POST).options(requestOptions).requestData(data).params(params).build());
    }

    public Status bountyCancel(String activityId) {
        return this.bountyCancel(ActivityBountyCancelParams.builder().activityId(activityId).build());
    }

    public Status bountyCancel(ActivityBountyCancelParams params) {
        return this.bountyCancel(params, RequestOptions.create());
    }

    public Status bountyCancel(ActivityBountyCancelParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(ACTIVITIES_BOUNTY_CANCEL_URI).responseClass(Status.class).method(HttpMethod.POST).options(requestOptions).params(params).build());
    }

    public Status bountyAward(String activityId, String uuid) {
        return this.bountyAward(ActivityBountyAwardParams.builder().activityId(activityId).uuid(uuid).build());
    }

    public Status bountyAward(ActivityBountyAwardParams params) {
        return this.bountyAward(params, RequestOptions.create());
    }

    public Status bountyAward(ActivityBountyAwardParams params, RequestOptions requestOptions) {
        return (Status)this.apiClient().request(ApiRequest.builder().apiPath(ACTIVITIES_BOUNTY_AWARD_URI).responseClass(Status.class).method(HttpMethod.POST).options(requestOptions).params(params).build());
    }

    public ActivityDto get(String activityId) {
        return this.get(ActivityGetParams.builder().activityId(activityId).build());
    }

    public ActivityDto get(ActivityGetParams params) {
        return this.get(params, RequestOptions.create());
    }

    public ActivityDto get(ActivityGetParams params, RequestOptions requestOptions) {
        return (ActivityDto)this.apiClient().request(ApiRequest.builder().apiPath(ACTIVITIES_ID_URI).responseClass(ActivityDto.class).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public List<ActivityDto> getActivities(String siteUrl) {
        return this.getActivities(ActivityGetListParams.builder().siteUrl(siteUrl).build());
    }

    public List<ActivityDto> getActivities(ActivityGetListParams params) {
        return this.getActivities(params, RequestOptions.create());
    }

    public List<ActivityDto> getActivities(ActivityGetListParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(ACTIVITIES_SITE_URI).responseClass(ActivityDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public List<ActivityDto> getActivitiesByUser(String siteUrl, String uuid) {
        return this.getActivitiesByUser(ActivityGetListByUserParams.builder().siteUrl(siteUrl).uuid(uuid).build(), RequestOptions.create());
    }

    public List<ActivityDto> getActivitiesByUser(ActivityGetListByUserParams params) {
        return this.getActivitiesByUser(params, RequestOptions.create());
    }

    public List<ActivityDto> getActivitiesByUser(ActivityGetListByUserParams params, RequestOptions requestOptions) {
        return (List)this.apiClient().request(ApiRequest.builder().apiPath(ACTIVITIES_USER_URI).responseClass(ActivityDto.class).responseType(ResponseType.LIST).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public ProcessingStatusDto getProcessingStatus(String activityId) {
        return this.getProcessingStatus(ActivityProcessingStatusParams.builder().activityId(activityId).build());
    }

    public ProcessingStatusDto getProcessingStatus(ActivityProcessingStatusParams params) {
        return this.getProcessingStatus(params, RequestOptions.create());
    }

    public ProcessingStatusDto getProcessingStatus(ActivityProcessingStatusParams params, RequestOptions requestOptions) {
        return (ProcessingStatusDto)this.apiClient().request(ApiRequest.builder().apiPath(ACTIVITIES_STATUS_URI).responseClass(ProcessingStatusDto.class).method(HttpMethod.GET).options(requestOptions).params(params).build());
    }

    public ActivityRequestData newActivityRequestData() {
        return new ActivityRequestData();
    }

    public RejectActivityRequestData newRejectActivityRequestData() {
        return new RejectActivityRequestData();
    }

    public RejectActivityCriteriaRequestData newRejectActivityCriteriaRequestData() {
        return new RejectActivityCriteriaRequestData();
    }
}

