/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.http.client;

import io.mambo.sdk.ClientConfiguration;
import io.mambo.sdk.http.HttpHeaders;
import io.mambo.sdk.http.HttpRequest;
import io.mambo.sdk.http.HttpResponse;
import io.mambo.sdk.utils.MamboLogger;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;

public class HttpClientLogger {
    private final ClientConfiguration configuration;
    private final MamboLogger logger;

    public HttpClientLogger(ClientConfiguration configuration) {
        this.configuration = configuration;
        this.logger = new MamboLogger(configuration);
    }

    public void log(String logMessage) {
        this.logger.log(logMessage);
    }

    public void logRequest(int requestId, HttpRequest request) {
        if (!this.configuration.hasLogging()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%s > %s %s%n", requestId, request.method().name(), request.url()));
        this.addHeaders(requestId, request.headers(), ">", builder);
        if (request.hasContent()) {
            String contentAsString = new String(request.content().contentByteArray(), StandardCharsets.UTF_8);
            builder.append(String.format("%s > %n%s%n", requestId, contentAsString.trim()));
        }
        this.logger.log("MamboClient sent a request on thread {}\n{}", Thread.currentThread().getName(), builder);
    }

    private void addHeaders(int requestId, HttpHeaders headers, String separator, StringBuilder builder) {
        builder.append(headers.entrySet().stream().map(entry -> requestId + " " + separator + " " + (String)entry.getKey() + ": " + String.join((CharSequence)", ", (Iterable)entry.getValue())).collect(Collectors.joining(System.lineSeparator()))).append(System.lineSeparator());
    }

    public void logResponse(int requestId, HttpResponse response) {
        if (!this.configuration.hasLogging()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%s < %s%n", new Object[]{requestId, response.code()}));
        this.addHeaders(requestId, response.headers(), "<", builder);
        if (response.hasContent()) {
            builder.append(String.format("%s < %n%s%n", requestId, response.content()));
        }
        this.logger.log("MamboClient received a response on thread {}\n{}", Thread.currentThread().getName(), builder);
    }
}

