/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.http.client;

import io.mambo.sdk.ClientConfiguration;
import io.mambo.sdk.exception.ApiConnectionException;
import io.mambo.sdk.exception.MamboException;
import io.mambo.sdk.http.HttpHeaders;
import io.mambo.sdk.http.HttpRequest;
import io.mambo.sdk.http.HttpResponse;
import io.mambo.sdk.http.HttpStatus;
import io.mambo.sdk.http.NoOpTrustManager;
import io.mambo.sdk.http.client.HttpClient;
import io.mambo.sdk.http.client.HttpClientLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class DefaultHttpClient
implements HttpClient {
    private static final AtomicInteger requestCount = new AtomicInteger(1);
    private final HttpClientLogger logger;

    public DefaultHttpClient(ClientConfiguration configuration) {
        this.logger = new HttpClientLogger(configuration);
    }

    @Override
    public HttpResponse request(HttpRequest request) {
        try {
            int requestId = requestCount.incrementAndGet();
            this.logger.logRequest(requestId, request);
            HttpResponse response = this.executeRequest(request);
            this.logger.logResponse(requestId, response);
            return response;
        }
        catch (IOException exception) {
            throw new ApiConnectionException(exception);
        }
    }

    private HttpResponse executeRequest(HttpRequest request) throws IOException {
        HttpURLConnection connection = this.buildConnection(request);
        HttpStatus status = HttpStatus.valueOf(connection.getResponseCode());
        HttpHeaders headers = HttpHeaders.of(connection.getHeaderFields());
        InputStream bodyStream = this.responseBody(connection, status);
        return new HttpResponse(status, headers, bodyStream);
    }

    private HttpURLConnection buildConnection(HttpRequest request) throws IOException {
        HttpURLConnection connection = this.openConnection(request);
        connection.setConnectTimeout(request.options().connectionTimeout());
        connection.setReadTimeout(request.options().readTimeout());
        connection.setRequestMethod(request.method().name());
        connection.setUseCaches(false);
        this.addHeaders(connection, request);
        this.addContent(connection, request);
        return connection;
    }

    private HttpURLConnection openConnection(HttpRequest request) throws IOException {
        if (request.options().hasProxy()) {
            return this.openProxyConnection(request);
        }
        return (HttpURLConnection)request.url().openConnection();
    }

    private HttpURLConnection openProxyConnection(HttpRequest request) throws IOException {
        Proxy proxy = request.options().proxy();
        HttpURLConnection connection = (HttpURLConnection)request.url().openConnection(proxy);
        this.addProxyAuthentication(request, connection);
        return connection;
    }

    private void addProxyAuthentication(HttpRequest request, HttpURLConnection connection) {
        if (request.options().hasProxyCredentials()) {
            String credentials = request.options().encodedProxyCredentials();
            connection.setRequestProperty("Proxy-Authorization", "Basic " + credentials);
        }
    }

    private void addHeaders(HttpURLConnection connection, HttpRequest request) {
        for (Map.Entry<String, List<String>> entry : request.headers().entrySet()) {
            connection.setRequestProperty(entry.getKey(), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)entry.getValue()));
        }
    }

    private void addContent(HttpURLConnection connection, HttpRequest request) throws IOException {
        if (!request.hasContent()) {
            return;
        }
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", request.content().contentType());
        try (OutputStream output = connection.getOutputStream();){
            output.write(request.content().contentByteArray());
        }
    }

    private InputStream responseBody(HttpURLConnection connection, HttpStatus status) throws IOException {
        return status.is2xxSuccessful() ? connection.getInputStream() : connection.getErrorStream();
    }

    @Override
    public void disableSslVerification() {
        try {
            HostnameVerifier verifier = (urlHostName, session) -> true;
            TrustManager[] trustAllCerts = new TrustManager[]{new NoOpTrustManager()};
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(verifier);
            SSLContext.setDefault(sslContext);
            this.logger.log("Disabled SSL verification");
        }
        catch (Exception exception) {
            throw new MamboException("Error disabling SSL verification.", exception);
        }
    }
}

