/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.http.authenticator;

import io.mambo.sdk.exception.MamboApiException;
import io.mambo.sdk.exception.MamboExceptionFactory;
import io.mambo.sdk.http.HttpContent;
import io.mambo.sdk.http.HttpHeaders;
import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.HttpParams;
import io.mambo.sdk.http.HttpRequest;
import io.mambo.sdk.http.HttpResponse;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.authenticator.AccessToken;
import io.mambo.sdk.http.authenticator.Authenticator;
import io.mambo.sdk.http.authenticator.MamboCredentials;
import io.mambo.sdk.http.client.HttpClient;
import io.mambo.sdk.utils.JsonUtils;
import io.mambo.sdk.utils.StringUtils;

public class OAuthAuthenticator
implements Authenticator {
    private static final MamboExceptionFactory exceptionFactory = new MamboExceptionFactory();
    private static final String ACCESS_TOKEN_URL = "/oauth/token";
    private final HttpClient httpClient;
    private final MamboCredentials credentials;
    private String oauthToken = null;

    public OAuthAuthenticator(MamboCredentials credentials, HttpClient httpClient) {
        this.credentials = credentials;
        this.httpClient = httpClient;
    }

    @Override
    public void authenticate(HttpHeaders headers, RequestOptions options) {
        String bearerToken = this.fetchOAuthToken(headers, options);
        headers.addHeader("Authorization", "Bearer " + bearerToken);
    }

    private String fetchOAuthToken(HttpHeaders headers, RequestOptions options) {
        if (StringUtils.isNotEmpty(this.oauthToken)) {
            return this.oauthToken;
        }
        this.refreshOAuthToken(headers, options);
        return this.oauthToken;
    }

    private void refreshOAuthToken(HttpHeaders headers, RequestOptions options) {
        HttpRequest request = this.toHttpRequest(headers, options);
        HttpResponse response = this.httpClient.request(request);
        if (!response.code().is2xxSuccessful()) {
            throw this.createException(response);
        }
        this.oauthToken = this.toAccessToken(response);
    }

    private String toAccessToken(HttpResponse response) {
        AccessToken accessToken = (AccessToken)JsonUtils.deserialize(response.content(), AccessToken.class);
        return accessToken.getAccessToken();
    }

    private HttpRequest toHttpRequest(HttpHeaders headers, RequestOptions options) {
        return new HttpRequest(this.buildOAuthUrl(options), HttpMethod.POST, this.buildBasicAuthHeaders(headers), HttpParams.empty(), HttpContent.form("grant_type=client_credentials"), options);
    }

    private String buildOAuthUrl(RequestOptions options) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(options.serverBaseUrl());
        urlBuilder.append(ACCESS_TOKEN_URL);
        return urlBuilder.toString();
    }

    private HttpHeaders buildBasicAuthHeaders(HttpHeaders headers) {
        return HttpHeaders.of(headers).addHeader("Authorization", "Basic " + this.credentials.encodedCredentials());
    }

    private MamboApiException createException(HttpResponse response) {
        return exceptionFactory.createMamboApiException(response.content(), response.code());
    }

    @Override
    public void invalidate() {
        this.oauthToken = null;
    }
}

