/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.http.authenticator;

import io.mambo.sdk.http.authenticator.MamboCredentials;
import io.mambo.sdk.utils.Preconditions;
import io.mambo.sdk.utils.StringUtils;
import java.util.Base64;

public class DefaultMamboCredentials
implements MamboCredentials {
    private final String publicKey;
    private final String privateKey;

    public DefaultMamboCredentials(String publicKey, String privateKey) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(publicKey), "publicKey must not be null or empty");
        Preconditions.checkArgument(StringUtils.isNotEmpty(privateKey), "privateKey must not be null or empty");
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    @Override
    public String encodedCredentials() {
        byte[] credentialBytes = (this.publicKey + ":" + this.privateKey).getBytes();
        return Base64.getEncoder().encodeToString(credentialBytes);
    }
}

