/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.http.api;

import io.mambo.sdk.ClientConfiguration;
import io.mambo.sdk.Version;
import io.mambo.sdk.exception.MamboApiException;
import io.mambo.sdk.exception.MamboExceptionFactory;
import io.mambo.sdk.exception.oauth.InvalidTokenException;
import io.mambo.sdk.http.HttpContent;
import io.mambo.sdk.http.HttpHeaders;
import io.mambo.sdk.http.HttpParams;
import io.mambo.sdk.http.HttpRequest;
import io.mambo.sdk.http.HttpResponse;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.api.ApiRequest;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.http.authenticator.Authenticator;
import io.mambo.sdk.http.authenticator.MamboCredentials;
import io.mambo.sdk.http.authenticator.OAuthAuthenticator;
import io.mambo.sdk.http.client.DefaultHttpClient;
import io.mambo.sdk.http.client.HttpClient;
import io.mambo.sdk.utils.JsonUtils;
import io.mambo.sdk.utils.ObjectUtils;
import io.mambo.sdk.utils.Preconditions;

public class DefaultApiRequestAdapter
implements ApiRequestAdapter {
    private static final MamboExceptionFactory exceptionFactory = new MamboExceptionFactory();
    private static final String API_BASE_PATH = "/api";
    private final Version version = new Version();
    private final HttpClient httpClient;
    private final Authenticator authenticator;
    private final ClientConfiguration configuration;

    public DefaultApiRequestAdapter(MamboCredentials credentials, ClientConfiguration configuration) {
        this(credentials, configuration, null, null);
    }

    public DefaultApiRequestAdapter(MamboCredentials credentials, ClientConfiguration configuration, HttpClient client, Authenticator authenticator) {
        Preconditions.checkNotNull(credentials, "credentials must not be null");
        Preconditions.checkNotNull(configuration, "configuration must not be null");
        this.configuration = configuration;
        this.httpClient = this.buildHttpClient(configuration, client);
        this.authenticator = this.buildAuthenticator(credentials, authenticator);
        this.sslConfiguration();
    }

    private HttpClient buildHttpClient(ClientConfiguration configuration, HttpClient client) {
        return ObjectUtils.getOrDefault(client, new DefaultHttpClient(configuration));
    }

    private Authenticator buildAuthenticator(MamboCredentials credentials, Authenticator authenticator) {
        return ObjectUtils.getOrDefault(authenticator, new OAuthAuthenticator(credentials, this.httpClient));
    }

    private void sslConfiguration() {
        if (!this.configuration.hasSslVerification()) {
            this.httpClient.disableSslVerification();
        }
    }

    @Override
    public String getVersion() {
        return this.version.getVersion();
    }

    @Override
    public <T> T request(ApiRequest apiRequest) {
        HttpRequest request = this.toHttpRequest(apiRequest);
        HttpResponse response = this.httpClient.request(request);
        if (!response.code().is2xxSuccessful()) {
            return this.handleError(apiRequest, response);
        }
        return this.deserializeResponse(apiRequest, response);
    }

    private HttpRequest toHttpRequest(ApiRequest apiRequest) {
        RequestOptions options = this.mergeDefaultOptions(apiRequest.options());
        return new HttpRequest(this.buildResourceUrl(apiRequest, options), apiRequest.method(), this.buildBaseHeaders(options), HttpParams.of(apiRequest.params()), HttpContent.of(apiRequest.requestData()), options);
    }

    private String buildResourceUrl(ApiRequest apiRequest, RequestOptions options) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(options.serverBaseUrl());
        urlBuilder.append(API_BASE_PATH);
        urlBuilder.append(apiRequest.apiPath());
        return urlBuilder.toString();
    }

    private HttpHeaders buildBaseHeaders(RequestOptions options) {
        HttpHeaders headers = new HttpHeaders().addHeader("User-Agent", this.userAgent()).addHeader("Accept-Version", this.getVersion()).addHeader("Accept", "application/json");
        this.authenticator.authenticate(headers, options);
        return headers;
    }

    private String userAgent() {
        return "Mambo/" + this.getVersion() + "; Java " + System.getProperty("java.version");
    }

    private RequestOptions mergeDefaultOptions(RequestOptions requestOptions) {
        return requestOptions.merge(this.configuration);
    }

    private <T> T handleError(ApiRequest apiRequest, HttpResponse response) {
        MamboApiException exception = this.createException(response);
        if (exception instanceof InvalidTokenException) {
            this.authenticator.invalidate();
            return this.request(apiRequest);
        }
        throw exception;
    }

    private MamboApiException createException(HttpResponse response) {
        return exceptionFactory.createMamboApiException(response.content(), response.code());
    }

    private <T> T deserializeResponse(ApiRequest apiRequest, HttpResponse response) {
        return JsonUtils.deserialize(response.content(), apiRequest.responseClass(), apiRequest.responseType());
    }
}

