/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.http.api;

import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.RequestOptions;
import io.mambo.sdk.http.ResponseType;
import io.mambo.sdk.service.common.data.RequestData;
import io.mambo.sdk.service.common.param.ServiceParams;
import io.mambo.sdk.utils.Multimap;
import io.mambo.sdk.utils.Preconditions;

public class ApiRequest {
    private final String apiPath;
    private final Class<?> responseClass;
    private final ResponseType responseType;
    private final HttpMethod method;
    private final RequestData requestData;
    private final RequestOptions options;
    private final ServiceParams params;

    private ApiRequest(Builder builder) {
        this.apiPath = builder.apiPath;
        this.responseClass = builder.responseClass;
        this.method = builder.method;
        this.requestData = builder.requestData;
        this.responseType = builder.responseType;
        this.options = builder.options;
        this.params = builder.params;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String apiPath() {
        return this.apiPath;
    }

    public Class<?> responseClass() {
        return this.responseClass;
    }

    public ResponseType responseType() {
        return this.responseType;
    }

    public HttpMethod method() {
        return this.method;
    }

    public RequestData requestData() {
        return this.requestData;
    }

    public RequestOptions options() {
        return this.options;
    }

    public Multimap<String, String> params() {
        if (this.params == null) {
            return new Multimap<String, String>();
        }
        return this.params.asMap();
    }

    public static class Builder {
        private String apiPath;
        private Class<?> responseClass;
        private ResponseType responseType = ResponseType.OBJECT;
        private HttpMethod method;
        private RequestData requestData;
        private RequestOptions options = RequestOptions.create();
        private ServiceParams params;

        private Builder() {
        }

        public Builder apiPath(String apiPath) {
            this.apiPath = apiPath;
            return this;
        }

        public Builder responseClass(Class<?> responseClass) {
            this.responseClass = responseClass;
            return this;
        }

        public Builder responseType(ResponseType responseType) {
            this.responseType = responseType;
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder requestData(RequestData requestData) {
            this.requestData = requestData;
            return this;
        }

        public Builder options(RequestOptions options) {
            this.options = options;
            return this;
        }

        public Builder params(ServiceParams params) {
            this.params = params;
            return this;
        }

        public ApiRequest build() {
            this.validateRequest();
            return new ApiRequest(this);
        }

        private void validateRequest() {
            Preconditions.checkNotNull(this.apiPath, "apiPath must not be null");
            Preconditions.checkNotNull(this.responseClass, "responseClass must not be null");
            Preconditions.checkNotNull(this.responseType, "responseType must not be null");
            Preconditions.checkNotNull(this.method, "method must not be null");
        }
    }
}

