/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.http;

import io.mambo.sdk.ClientConfiguration;
import io.mambo.sdk.utils.HttpUtils;
import io.mambo.sdk.utils.ObjectUtils;
import io.mambo.sdk.utils.Preconditions;
import io.mambo.sdk.utils.StringUtils;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import lombok.Generated;

public class RequestOptions {
    private final String serverBaseUrl;
    private final String language;
    private final Integer readTimeoutMillis;
    private final Integer connectionTimeoutMillis;
    private final Proxy proxy;
    private final String proxyUsername;
    private final String proxyPassword;
    private final UUID idempotencyKey;

    private RequestOptions(Builder builder) {
        this.serverBaseUrl = builder.serverBaseUrl;
        this.language = builder.language;
        this.readTimeoutMillis = builder.readTimeoutMillis;
        this.connectionTimeoutMillis = builder.connectionTimeoutMillis;
        this.proxy = builder.proxy;
        this.proxyUsername = builder.proxyUsername;
        this.proxyPassword = builder.proxyPassword;
        this.idempotencyKey = builder.idempotencyKey;
    }

    private RequestOptions(String serverBaseUrl, String language, Integer readTimeoutMillis, Integer connectionTimeoutMillis, Proxy proxy, String proxyUsername, String proxyPassword, UUID idempotencyKey) {
        this.serverBaseUrl = serverBaseUrl;
        this.language = language;
        this.readTimeoutMillis = readTimeoutMillis;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        this.proxy = proxy;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.idempotencyKey = idempotencyKey;
    }

    public static RequestOptions create() {
        return new RequestOptions(null, null, null, null, null, null, null, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String serverBaseUrl() {
        return this.serverBaseUrl;
    }

    public String language() {
        return this.language;
    }

    public boolean hasProxy() {
        return this.proxy != null;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public boolean hasProxyCredentials() {
        return StringUtils.isNotBlank(this.proxyUsername) && StringUtils.isNotBlank(this.proxyPassword);
    }

    public String encodedProxyCredentials() {
        String auth = this.proxyUsername + ":" + this.proxyPassword;
        return Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
    }

    public Integer connectionTimeout() {
        return this.connectionTimeoutMillis;
    }

    public Integer readTimeout() {
        return this.readTimeoutMillis;
    }

    public boolean hasIdempotencyKey() {
        return this.idempotencyKey != null;
    }

    public String idempotencyKey() {
        return this.hasIdempotencyKey() ? this.idempotencyKey.toString() : null;
    }

    public RequestOptions merge(ClientConfiguration configuration) {
        return new RequestOptions(ObjectUtils.getOrDefault(this.serverBaseUrl, configuration.getServerBaseUrl()), ObjectUtils.getOrDefault(this.language, configuration.getLanguage()), ObjectUtils.getOrDefault(this.readTimeoutMillis, configuration.getReadTimeoutMillis()), ObjectUtils.getOrDefault(this.connectionTimeoutMillis, configuration.getConnectionTimeoutMillis()), ObjectUtils.getOrDefault(this.proxy, configuration.getProxy()), ObjectUtils.getOrDefault(this.proxyUsername, configuration.getProxyUsername()), ObjectUtils.getOrDefault(this.proxyPassword, configuration.getProxyPassword()), this.idempotencyKey);
    }

    @Generated
    public String toString() {
        return "RequestOptions(serverBaseUrl=" + this.serverBaseUrl + ", language=" + this.language + ", readTimeoutMillis=" + this.readTimeoutMillis + ", connectionTimeoutMillis=" + this.connectionTimeoutMillis + ", proxy=" + this.proxy + ", proxyUsername=" + this.proxyUsername + ", proxyPassword=" + this.proxyPassword + ", idempotencyKey=" + this.idempotencyKey + ")";
    }

    public static class Builder {
        private String serverBaseUrl;
        private String language;
        private Integer readTimeoutMillis;
        private Integer connectionTimeoutMillis;
        private Proxy proxy;
        private String proxyUsername;
        private String proxyPassword;
        private UUID idempotencyKey;

        private Builder() {
        }

        public Builder serverBaseUrl(String serverBaseUrl) {
            Preconditions.checkArgument(StringUtils.isNotBlank(serverBaseUrl), "serverBaseUrl must not be null or empty");
            Preconditions.checkArgument(StringUtils.startsWith(serverBaseUrl, "http"), "serverBaseUrl must include the protocol (e.g. https://)");
            this.serverBaseUrl = StringUtils.removeEnd(serverBaseUrl, "/");
            return this;
        }

        public Builder language(String language) {
            Preconditions.checkArgument(StringUtils.isNotBlank(language), "language must not be null or empty");
            this.language = language;
            return this;
        }

        public Builder proxyUri(String proxyUri) {
            Preconditions.checkArgument(StringUtils.isNotBlank(proxyUri), "proxyUri must not be null or empty");
            this.proxy = HttpUtils.buildProxy(proxyUri);
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyUsername(String proxyUsername) {
            this.proxyUsername = proxyUsername;
            return this;
        }

        public Builder proxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        public Builder readTimeoutMillis(Integer readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public Builder connectionTimeoutMillis(Integer connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
            return this;
        }

        public Builder idempotencyKey(UUID idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public RequestOptions build() {
            return new RequestOptions(this);
        }
    }
}

