/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.http;

import io.mambo.sdk.exception.MamboException;
import io.mambo.sdk.utils.JsonUtils;
import io.mambo.sdk.utils.StreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

public class MultipartBuilder {
    private static final String CRLF = "\r\n";
    private final String boundary;
    private final ByteArrayOutputStream outputStream;
    private final Writer writer;

    public MultipartBuilder(String boundary) {
        this.boundary = boundary;
        this.outputStream = new ByteArrayOutputStream();
        this.writer = new OutputStreamWriter((OutputStream)this.outputStream, StandardCharsets.UTF_8);
    }

    public MultipartBuilder addFileField(String partName, File file) {
        try {
            this.writeLine("--" + this.boundary);
            this.writeLine(String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"", partName, file.getName()));
            this.writeLine("Content-Type: " + this.detectContentType(file));
            this.writeEmptyLine();
            StreamUtils.copy(new FileInputStream(file), this.outputStream);
            this.writeEmptyLine();
            return this;
        }
        catch (IOException exception) {
            throw new MamboException("Failed to add multipart file content", exception);
        }
    }

    private void writeLine(String line) throws IOException {
        this.writer.write(line);
        this.writer.write(CRLF);
        this.writer.flush();
    }

    private void writeEmptyLine() throws IOException {
        this.writeLine("");
    }

    private String detectContentType(File file) {
        try {
            String contentType = Files.probeContentType(file.toPath());
            return contentType != null ? contentType : "application/octet-stream";
        }
        catch (IOException e) {
            return "application/octet-stream";
        }
    }

    public MultipartBuilder addJsonField(String name, Object value) {
        try {
            this.writePartHeader(name, "application/json");
            this.writeLine(JsonUtils.serialize(value));
            return this;
        }
        catch (IOException exception) {
            throw new MamboException("Failed to add multipart JSON field", exception);
        }
    }

    private void writePartHeader(String partName, String contentType) throws IOException {
        this.writeLine("--" + this.boundary);
        this.writeLine(String.format("Content-Disposition: form-data; name=\"%s\"", partName));
        this.writeLine("Content-Type: " + contentType);
        this.writeEmptyLine();
    }

    public byte[] build() {
        try {
            this.writeLine("--" + this.boundary + "--");
            this.flushAndCloseStreams();
            return this.outputStream.toByteArray();
        }
        catch (IOException exception) {
            throw new MamboException("Failed to build multipart content", exception);
        }
    }

    private void flushAndCloseStreams() throws IOException {
        this.writer.flush();
        this.writer.close();
        this.outputStream.flush();
        this.outputStream.close();
    }
}

