/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.http;

import io.mambo.sdk.exception.MamboException;
import io.mambo.sdk.http.HttpContent;
import io.mambo.sdk.http.HttpHeaders;
import io.mambo.sdk.http.HttpMethod;
import io.mambo.sdk.http.HttpParams;
import io.mambo.sdk.http.RequestOptions;
import java.io.IOException;
import java.net.URL;

public class HttpRequest {
    private final URL resourceUrl;
    private final HttpMethod method;
    private final HttpContent content;
    private final HttpHeaders headers;
    private final HttpParams parameters;
    private final RequestOptions options;

    public HttpRequest(String resourceUrl, HttpMethod method, HttpHeaders headers, HttpParams parameters, HttpContent content, RequestOptions options) {
        this.method = method;
        this.content = content;
        this.parameters = parameters;
        this.options = options;
        this.resourceUrl = this.buildUrl(resourceUrl, parameters);
        this.headers = this.builderHeaders(headers, content, options);
    }

    private URL buildUrl(String resourceUrl, HttpParams parameters) {
        try {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(parameters.resolvePath(resourceUrl));
            urlBuilder.append(parameters.buildQueryString());
            return new URL(urlBuilder.toString());
        }
        catch (IOException exception) {
            throw new MamboException("Error building request URL", exception);
        }
    }

    private HttpHeaders builderHeaders(HttpHeaders headers, HttpContent content, RequestOptions options) {
        return headers.addHeaderIf(options.hasIdempotencyKey(), "Idempotency-Key", options.idempotencyKey()).addHeaderIf(content.hasContent(), "Content-Type", content.contentType()).addHeader("Accept-Language", options.language());
    }

    public URL url() {
        return this.resourceUrl;
    }

    public HttpMethod method() {
        return this.method;
    }

    public boolean hasContent() {
        return this.content.hasContent();
    }

    public HttpContent content() {
        return this.content;
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    public HttpParams parameters() {
        return this.parameters;
    }

    public RequestOptions options() {
        return this.options;
    }
}

