/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.http;

import io.mambo.sdk.exception.MamboException;
import io.mambo.sdk.utils.Multimap;
import io.mambo.sdk.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class HttpParams {
    private static final Pattern PATH_PARAM_PATTERN = Pattern.compile("\\{([^}]+)}");
    private final Multimap<String, String> params;

    private HttpParams(Multimap<String, String> params) {
        this.params = params;
    }

    public static HttpParams of(Multimap<String, String> params) {
        return new HttpParams(params);
    }

    public static HttpParams empty() {
        return new HttpParams(new Multimap<String, String>());
    }

    public String resolvePath(String path) {
        if (StringUtils.isBlank(path)) {
            return path;
        }
        Matcher matcher = PATH_PARAM_PATTERN.matcher(path);
        String resolvedPath = path;
        while (matcher.find()) {
            String paramName = matcher.group(1);
            String paramValue = this.params.getFirst(paramName);
            if (!StringUtils.isNotEmpty(paramValue)) continue;
            resolvedPath = resolvedPath.replace("{" + paramName + "}", paramValue);
            this.params.removeAll(paramName);
        }
        return resolvedPath;
    }

    public String buildQueryString() {
        if (this.params.isEmpty()) {
            return "";
        }
        return this.params.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> this.encode((String)entry.getKey()) + "=" + this.encode((String)value))).collect(Collectors.joining("&", "?", ""));
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException exception) {
            throw new MamboException("Error encoding URL parameter", exception);
        }
    }
}

