/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.http;

import io.mambo.sdk.utils.Multimap;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpHeaders {
    private final Multimap<String, String> headers;

    public HttpHeaders() {
        this.headers = new Multimap();
    }

    private HttpHeaders(Multimap<String, String> headers) {
        this.headers = headers;
    }

    public static HttpHeaders of(Map<String, List<String>> headers) {
        return new HttpHeaders(Multimap.of(headers));
    }

    public static HttpHeaders of(Multimap<String, String> headers) {
        return new HttpHeaders(headers);
    }

    public static HttpHeaders of(HttpHeaders headers) {
        return new HttpHeaders(Multimap.of(headers.headers));
    }

    public HttpHeaders addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public HttpHeaders addHeader(AbstractMap.SimpleEntry<String, String> header) {
        this.headers.put(header.getKey(), header.getValue());
        return this;
    }

    public HttpHeaders addHeaderIf(boolean condition, String key, String value) {
        if (condition) {
            this.headers.put(key, value);
        }
        return this;
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.headers.entrySet();
    }
}

