/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.http;

import io.mambo.sdk.http.MultipartBuilder;
import io.mambo.sdk.service.common.data.FileRequestData;
import io.mambo.sdk.service.common.data.RequestData;
import io.mambo.sdk.utils.JsonUtils;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public class HttpContent {
    private final byte[] contentByteArray;
    private final String contentType;

    public HttpContent(byte[] contentByteArray, String contentType) {
        this.contentByteArray = contentByteArray;
        this.contentType = contentType;
    }

    public static HttpContent empty() {
        return HttpContent.buildEmptyContent();
    }

    public static HttpContent of(RequestData requestData) {
        if (requestData == null) {
            return HttpContent.buildEmptyContent();
        }
        if (requestData instanceof FileRequestData) {
            return HttpContent.buildMultipartContent((FileRequestData)requestData);
        }
        return HttpContent.buildJsonContent(requestData);
    }

    private static HttpContent buildEmptyContent() {
        return new HttpContent(new byte[0], "application/json;charset=utf-8");
    }

    private static HttpContent buildMultipartContent(FileRequestData requestData) {
        String boundary = UUID.randomUUID().toString();
        return new HttpContent(HttpContent.serializeMultipart(requestData, boundary), String.format("multipart/form-data;boundary=%s", boundary));
    }

    private static byte[] serializeMultipart(FileRequestData requestData, String boundary) {
        MultipartBuilder multipart = new MultipartBuilder(boundary);
        multipart.addFileField("image", requestData.getFile());
        if (requestData.hasData()) {
            multipart.addJsonField("data", requestData.getData());
        }
        return multipart.build();
    }

    private static HttpContent buildJsonContent(RequestData requestData) {
        return new HttpContent(HttpContent.serializeJson(requestData), "application/json;charset=utf-8");
    }

    private static byte[] serializeJson(RequestData requestData) {
        return JsonUtils.serialize(requestData).getBytes(StandardCharsets.UTF_8);
    }

    public static HttpContent form(String content) {
        return new HttpContent(content.getBytes(StandardCharsets.UTF_8), "application/x-www-form-urlencoded;charset=utf-8");
    }

    public String contentType() {
        return this.contentType;
    }

    public byte[] contentByteArray() {
        return this.contentByteArray;
    }

    public boolean hasContent() {
        return this.contentByteArray.length > 0;
    }
}

