/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk.exception;

import io.mambo.sdk.exception.AuthenticationException;
import io.mambo.sdk.exception.IdempotencyException;
import io.mambo.sdk.exception.MamboApiException;
import io.mambo.sdk.exception.MamboError;
import io.mambo.sdk.exception.oauth.InvalidRequestException;
import io.mambo.sdk.exception.oauth.InvalidTokenException;
import io.mambo.sdk.exception.oauth.OAuthError;
import io.mambo.sdk.exception.oauth.OAuthException;
import io.mambo.sdk.exception.oauth.UnsupportedGrantTypeException;
import io.mambo.sdk.http.HttpStatus;
import io.mambo.sdk.utils.JsonUtils;
import io.mambo.sdk.utils.StringUtils;

public class MamboExceptionFactory {
    public MamboApiException createMamboApiException(String jsonResponse, HttpStatus status) {
        return this.createMamboApiException(jsonResponse, status, null);
    }

    public MamboApiException createMamboApiException(String jsonResponse, HttpStatus status, Throwable exception) {
        if (this.isOAuth2Exception(jsonResponse)) {
            return this.createOAuthException(jsonResponse, status);
        }
        MamboError error = this.parseError(jsonResponse);
        switch (error.getType()) {
            case "InvalidIdempotencyKeyException": 
            case "IdempotencyKeyAlreadyUsedException": 
            case "IdempotencyRequestInProgressException": {
                return new IdempotencyException(error, status);
            }
            case "UnauthorizedException": 
            case "ForbiddenException": {
                return new AuthenticationException(error, status);
            }
        }
        return new MamboApiException(error, status, exception);
    }

    private boolean isOAuth2Exception(String jsonResponse) {
        return StringUtils.contains(jsonResponse, "OAuth2Exception");
    }

    private OAuthException createOAuthException(String jsonResponse, HttpStatus status) {
        OAuthError error = this.parseOAuthError(jsonResponse);
        switch (error.getError()) {
            case "invalid_token": {
                return new InvalidTokenException(error, status);
            }
            case "invalid_request": {
                return new InvalidRequestException(error, status);
            }
            case "unsupported_grant_type": {
                return new UnsupportedGrantTypeException(error, status);
            }
        }
        return new OAuthException(error, status);
    }

    private OAuthError parseOAuthError(String jsonResponse) {
        return (OAuthError)JsonUtils.deserialize(jsonResponse, OAuthError.class);
    }

    private MamboError parseError(String jsonResponse) {
        return (MamboError)JsonUtils.deserialize(jsonResponse, MamboError.class);
    }
}

