/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk;

import io.mambo.sdk.ClientConfiguration;
import io.mambo.sdk.http.api.ApiRequestAdapter;
import io.mambo.sdk.http.api.DefaultApiRequestAdapter;
import io.mambo.sdk.http.authenticator.DefaultMamboCredentials;
import io.mambo.sdk.service.activity.ActivitiesService;
import io.mambo.sdk.service.analytics.AnalyticsService;
import io.mambo.sdk.service.behaviour.BehavioursService;
import io.mambo.sdk.service.coupon.CouponsService;
import io.mambo.sdk.service.customfield.CustomFieldsService;
import io.mambo.sdk.service.datastore.DataStoresService;
import io.mambo.sdk.service.kpi.KpisService;
import io.mambo.sdk.service.language.LanguagesService;
import io.mambo.sdk.service.leaderboard.LeaderboardsService;
import io.mambo.sdk.service.notification.NotificationsService;
import io.mambo.sdk.service.point.PointsService;
import io.mambo.sdk.service.reward.RewardsService;
import io.mambo.sdk.service.site.SitesService;
import io.mambo.sdk.service.tag.TagsService;
import io.mambo.sdk.service.user.UsersService;
import io.mambo.sdk.service.webhook.WebhooksService;
import io.mambo.sdk.utils.Preconditions;
import java.net.Proxy;

public class MamboClient {
    private final ApiRequestAdapter apiClient;

    public MamboClient(String publicKey, String privateKey) {
        this.apiClient = new DefaultApiRequestAdapter(new DefaultMamboCredentials(publicKey, privateKey), ClientConfiguration.builder().build());
    }

    public MamboClient(Builder builder) {
        this.apiClient = new DefaultApiRequestAdapter(new DefaultMamboCredentials(builder.publicKey, builder.privateKey), builder.configurer.build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public ActivitiesService activities() {
        return new ActivitiesService(this.apiClient);
    }

    public AnalyticsService analytics() {
        return new AnalyticsService(this.apiClient);
    }

    public BehavioursService behaviours() {
        return new BehavioursService(this.apiClient);
    }

    public CouponsService coupons() {
        return new CouponsService(this.apiClient);
    }

    public CustomFieldsService customFields() {
        return new CustomFieldsService(this.apiClient);
    }

    public DataStoresService dataStores() {
        return new DataStoresService(this.apiClient);
    }

    public KpisService kpis() {
        return new KpisService(this.apiClient);
    }

    public LanguagesService languages() {
        return new LanguagesService(this.apiClient);
    }

    public LeaderboardsService leaderboards() {
        return new LeaderboardsService(this.apiClient);
    }

    public NotificationsService notifications() {
        return new NotificationsService(this.apiClient);
    }

    public PointsService points() {
        return new PointsService(this.apiClient);
    }

    public RewardsService rewards() {
        return new RewardsService(this.apiClient);
    }

    public SitesService sites() {
        return new SitesService(this.apiClient);
    }

    public TagsService tags() {
        return new TagsService(this.apiClient);
    }

    public UsersService users() {
        return new UsersService(this.apiClient);
    }

    public WebhooksService webhooks() {
        return new WebhooksService(this.apiClient);
    }

    public static class Builder {
        private ClientConfiguration.Builder configurer = ClientConfiguration.builder();
        private String publicKey;
        private String privateKey;

        public Builder credentials(String publicKey, String privateKey) {
            this.publicKey = publicKey;
            this.privateKey = privateKey;
            return this;
        }

        public Builder serverBaseUrl(String serverBaseUrl) {
            this.configurer.serverBaseUrl(serverBaseUrl);
            return this;
        }

        public Builder enableLogging(boolean logging) {
            this.configurer.enableLogging(logging);
            return this;
        }

        public Builder sslVerification(boolean sslVerification) {
            this.configurer.sslVerification(sslVerification);
            return this;
        }

        public Builder language(String language) {
            this.configurer.language(language);
            return this;
        }

        public Builder proxyUri(String proxyUri) {
            this.configurer.proxyUri(proxyUri);
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.configurer.proxy(proxy);
            return this;
        }

        public Builder proxyUsername(String proxyUsername) {
            this.configurer.proxyUsername(proxyUsername);
            return this;
        }

        public Builder proxyPassword(String proxyPassword) {
            this.configurer.proxyPassword(proxyPassword);
            return this;
        }

        public Builder readTimeoutMillis(int readTimeoutMillis) {
            this.configurer.readTimeoutMillis(readTimeoutMillis);
            return this;
        }

        public Builder connectionTimeoutMillis(int connectionTimeoutMillis) {
            this.configurer.connectionTimeoutMillis(connectionTimeoutMillis);
            return this;
        }

        public MamboClient build() {
            Preconditions.checkNotNull(this.publicKey, "publicKey must not be null");
            Preconditions.checkNotNull(this.privateKey, "privateKey must not be null");
            return new MamboClient(this);
        }
    }
}

