/*
 * Decompiled with CFR 0.152.
 */
package io.mambo.sdk;

import io.mambo.sdk.utils.HttpUtils;
import io.mambo.sdk.utils.Preconditions;
import io.mambo.sdk.utils.StringUtils;
import java.net.Proxy;

public class ClientConfiguration {
    private final String serverBaseUrl;
    private final boolean logging;
    private final boolean sslVerification;
    private final String language;
    private final int readTimeoutMillis;
    private final int connectionTimeoutMillis;
    private final Proxy proxy;
    private final String proxyUsername;
    private final String proxyPassword;

    private ClientConfiguration(Builder builder) {
        this.serverBaseUrl = builder.serverBaseUrl;
        this.logging = builder.logging;
        this.sslVerification = builder.sslVerification;
        this.language = builder.language;
        this.readTimeoutMillis = builder.readTimeoutMillis;
        this.connectionTimeoutMillis = builder.connectionTimeoutMillis;
        this.proxy = builder.proxy;
        this.proxyUsername = builder.proxyUsername;
        this.proxyPassword = builder.proxyPassword;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getServerBaseUrl() {
        return this.serverBaseUrl;
    }

    public boolean hasLogging() {
        return this.logging;
    }

    public boolean hasSslVerification() {
        return this.sslVerification;
    }

    public String getLanguage() {
        return this.language;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public static class Builder {
        private String serverBaseUrl = "https://api.mambo.io";
        private boolean logging = false;
        private boolean sslVerification = true;
        private String language = "en";
        private int connectionTimeoutMillis = 20000;
        private int readTimeoutMillis = 61000;
        private Proxy proxy;
        private String proxyUsername;
        private String proxyPassword;

        private Builder() {
        }

        public Builder serverBaseUrl(String serverBaseUrl) {
            Preconditions.checkArgument(StringUtils.isNotBlank(serverBaseUrl), "serverBaseUrl must not be null or empty");
            Preconditions.checkArgument(StringUtils.startsWith(serverBaseUrl, "http"), "serverBaseUrl must include the protocol (e.g. https://)");
            this.serverBaseUrl = StringUtils.removeEnd(serverBaseUrl, "/");
            return this;
        }

        public Builder enableLogging(boolean logging) {
            this.logging = logging;
            return this;
        }

        public Builder sslVerification(boolean sslVerification) {
            this.sslVerification = sslVerification;
            return this;
        }

        public Builder language(String language) {
            Preconditions.checkArgument(StringUtils.isNotBlank(language), "language must not be null or empty");
            this.language = language;
            return this;
        }

        public Builder proxyUri(String proxyUri) {
            Preconditions.checkArgument(StringUtils.isNotBlank(proxyUri), "proxyUri must not be null or empty");
            this.proxy = HttpUtils.buildProxy(proxyUri);
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyUsername(String proxyUsername) {
            this.proxyUsername = proxyUsername;
            return this;
        }

        public Builder proxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        public Builder readTimeoutMillis(int readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public Builder connectionTimeoutMillis(int connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
            return this;
        }

        public ClientConfiguration build() {
            return new ClientConfiguration(this);
        }
    }
}

