/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.utils;

import java.util.ArrayList;
import java.util.List;

import io.mambo.sdk.service.tag.model.TagDto;

/**
 * Shared utility class for Tags
 */
public class TagUtils
{
	private TagUtils() {}


	/**
	 * Extracts the tag field from a {@link TagDto}
	 * @return
	 */
	public static String extractTag( TagDto tagDto )
	{
		if( tagDto == null ) {
			return null;
		}
		return tagDto.getTag();
	}


	/**
	 * Extracts the tag field from a list of {@link TagDto}
	 * @return
	 */
	public static List<String> extractTags( List<TagDto> tagDtos )
	{
		if( ListUtils.isEmpty( tagDtos ) ) {
			return ListUtils.newArrayList();
		}

		List<String> tags = new ArrayList<>();
		for( TagDto tagDto : tagDtos ) {
			tags.add( tagDto.getTag() );
		}
		return tags;
	}


	/**
	 * Extracts the tag ID field from a list of {@link TagDto}
	 * @return
	 */
	public static List<String> extractTagIds( List<TagDto> tagDtos )
	{
		if( ListUtils.isEmpty( tagDtos ) ) {
			return new ArrayList<>();
		}

		List<String> tagIds = new ArrayList<>();
		for( TagDto tagDto : tagDtos ) {
			tagIds.add( tagDto.getId() );
		}
		return tagIds;
	}
}
