/*
 * Copyright (C) 2014-2025 Mambo Solutions Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.mambo.sdk.utils;

public class StringUtils
{
	public static final String EMPTY = "";


	private StringUtils() {}


	public static boolean isEmpty( final CharSequence cs )
	{
		return cs == null || cs.length() == 0;
	}


	public static boolean isNotEmpty( final String str )
	{
		return !isEmpty( str );
	}


	public static boolean isBlank( final CharSequence cs )
	{
		final int strLen = length( cs );
		if( strLen == 0 ) {
			return true;
		}
		for( int i = 0; i < strLen; i++ ) {
			if( !Character.isWhitespace( cs.charAt( i ) ) ) {
				return false;
			}
		}
		return true;
	}


	public static int length( final CharSequence cs )
	{
		return cs == null ? 0 : cs.length();
	}


	public static boolean isNotBlank( final CharSequence cs )
	{
		return !isBlank( cs );
	}


	public static boolean contains( final String seq, final String searchSeq )
	{
		if( seq == null || searchSeq == null ) {
			return false;
		}
		return seq.contains( searchSeq );
	}


	public static boolean startsWith( final String str, final String prefix )
	{
		if( str == null || prefix == null ) {
			return str == prefix;
		}
		if( prefix.length() > str.length() ) {
			return false;
		}
		return str.startsWith( prefix );
	}


	public static boolean equals( final String str1, final String str2 )
	{
		if( str1 == null || str2 == null ) {
			return false;
		}
		if( str1.length() != str2.length() ) {
			return false;
		}
		return str1.equals( str2 );
	}


	public static String removeEnd( final String str, final String remove )
	{
		if( isEmpty( str ) || isEmpty( remove ) ) {
			return str;
		}
		if( str.endsWith( remove ) ) {
			return str.substring( 0, str.length() - remove.length() );
		}
		return str;
	}


	public static String lowerCase( final String str )
	{
		if( str == null ) {
			return null;
		}
		return str.toLowerCase();
	}
}
